/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.security.MessageDigest;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.AccountStoreFactory;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.services.LogService;

public class SimpleSecurityContext
extends ChainingSecurityContext
implements ISecurityContext {
    private final int SIMPLESECURITYAUTHTYPE = 65282;

    SimpleSecurityContext() {
    }

    public int getAuthType() {
        return this.SIMPLESECURITYAUTHTYPE;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        this.isauth = false;
        if (this.myPrincipal.UID != null && this.myOpaqueCredentials.credentialstring != null) {
            String first_name = null;
            String last_name = null;
            String md5_passwd = null;
            try {
                String[] acct = AccountStoreFactory.getAccountStoreImpl().getUserAccountInformation(this.myPrincipal.UID);
                if (acct[0] != null) {
                    first_name = acct[1];
                    last_name = acct[2];
                    md5_passwd = acct[0];
                    if (!md5_passwd.substring(0, 5).equals("(MD5)")) {
                        LogService.log(LogService.ERROR, "Password not an MD5 hash: " + md5_passwd.substring(0, 5));
                        return;
                    }
                    String txthash = md5_passwd.substring(5);
                    byte[] salt = new byte[8];
                    byte[] compare = new byte[16];
                    byte[] whole = SimpleSecurityContext.decode(txthash);
                    if (whole.length != 24) {
                        LogService.log(LogService.INFO, "Invalid MD5 hash value");
                        return;
                    }
                    System.arraycopy(whole, 0, salt, 0, 8);
                    System.arraycopy(whole, 8, compare, 0, 16);
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update(salt);
                    byte[] dgx = md.digest(this.myOpaqueCredentials.credentialstring);
                    boolean same = true;
                    for (int i = 0; i < dgx.length; ++i) {
                        if (dgx[i] == compare[i]) continue;
                        same = false;
                    }
                    if (same) {
                        this.myPrincipal.FullName = first_name + " " + last_name;
                        LogService.log(LogService.INFO, "User " + this.myPrincipal.UID + " is authenticated");
                        this.isauth = true;
                    }
                    LogService.log(LogService.INFO, "MD5 Password Invalid");
                }
                LogService.log(LogService.INFO, "No such user: " + this.myPrincipal.UID);
            }
            catch (Exception e) {
                PortalSecurityException ep = new PortalSecurityException("SQL Database Error");
                LogService.log(LogService.ERROR, e);
                throw ep;
            }
        } else {
            LogService.log(LogService.INFO, "Principal or OpaqueCredentials not initialized prior to authenticate");
        }
        super.authenticate();
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        for (int i2 = 0; i2 < base64.length(); i2 += 4) {
            int block = (SimpleSecurityContext.getValue(base64.charAt(i2)) << 18) + (SimpleSecurityContext.getValue(base64.charAt(i2 + 1)) << 12) + (SimpleSecurityContext.getValue(base64.charAt(i2 + 2)) << 6) + SimpleSecurityContext.getValue(base64.charAt(i2 + 3));
            for (int j = 0; j < 3 && rawIndex + j < raw.length; ++j) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawIndex += 3;
        }
        return raw;
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }
}

