/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.AccountStoreFactory;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.services.LogService;

class TrustSecurityContext
extends ChainingSecurityContext
implements ISecurityContext {
    private final int TRUSTSECURITYAUTHTYPE = 65281;

    TrustSecurityContext() {
    }

    public int getAuthType() {
        return this.TRUSTSECURITYAUTHTYPE;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        this.isauth = true;
        if (this.myPrincipal.UID != null) {
            try {
                String[] acct = AccountStoreFactory.getAccountStoreImpl().getUserAccountInformation(this.myPrincipal.UID);
                if (acct[0] != null) {
                    String first_name = acct[1];
                    String last_name = acct[2];
                    this.myPrincipal.FullName = first_name + " " + last_name;
                    LogService.log(LogService.INFO, "User " + this.myPrincipal.UID + " is authenticated");
                    this.isauth = true;
                }
                LogService.log(LogService.INFO, "No such user: " + this.myPrincipal.UID);
            }
            catch (Exception e) {
                PortalSecurityException ep = new PortalSecurityException("SQL Database Error");
                LogService.log(LogService.ERROR, ep);
                throw ep;
            }
        } else {
            LogService.log(LogService.ERROR, "Principal not initialized prior to authenticate");
        }
        super.authenticate();
    }
}

