/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jasig.portal.serialize.HTMLSerializer;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.Serializer;
import org.jasig.portal.serialize.SerializerFactory;
import org.jasig.portal.serialize.TextSerializer;
import org.jasig.portal.serialize.XHTMLSerializer;
import org.jasig.portal.serialize.XMLSerializer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String method) {
        this._method = method;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            throw new IllegalArgumentException("SER004 The method '" + method + "' is not supported by this factory\n" + method);
        }
    }

    public Serializer makeSerializer(OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputFormat(format);
        return serializer;
    }

    public Serializer makeSerializer(Writer writer, OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    public Serializer makeSerializer(OutputStream output, OutputFormat format) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputByteStream(output);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat format) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(format);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(format);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(format);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        throw new IllegalStateException("SER005 The method '" + this._method + "' is not supported by this factory\n" + this._method);
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

