/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jasig.portal.serialize.EncodingInfo;

public class SieveEncodingInfo
extends EncodingInfo {
    BAOutputStream checkerStream = null;
    Writer checkerWriter = null;
    String dangerChars = null;

    public SieveEncodingInfo(String mimeName, String javaName, int lastPrintable, String dangers) {
        super(mimeName, javaName, lastPrintable);
        this.dangerChars = dangers;
    }

    public SieveEncodingInfo(String mimeName, int lastPrintable) {
        this(mimeName, mimeName, lastPrintable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrintable(int ch) {
        if (this.dangerChars != null && ch <= 65535 && this.dangerChars.indexOf(ch) >= 0) {
            return false;
        }
        if (ch <= this.lastPrintable) {
            return true;
        }
        boolean printable = true;
        SieveEncodingInfo sieveEncodingInfo = this;
        synchronized (sieveEncodingInfo) {
            try {
                if (this.checkerWriter == null) {
                    this.checkerStream = new BAOutputStream(10);
                    this.checkerWriter = new OutputStreamWriter((OutputStream)this.checkerStream, this.javaName);
                }
                if (ch > 65535) {
                    this.checkerWriter.write((ch - 65536 >> 10) + 55296);
                    this.checkerWriter.write((ch - 65536 & 0x3FF) + 56320);
                    byte[] result = this.checkerStream.getBuffer();
                    if (this.checkerStream.size() == 2 && result[0] == 63 && result[1] == 63) {
                        printable = false;
                    }
                } else {
                    this.checkerWriter.write(ch);
                    this.checkerWriter.flush();
                    byte[] result = this.checkerStream.getBuffer();
                    if (this.checkerStream.size() == 1 && result[0] == 63) {
                        printable = false;
                    }
                }
                this.checkerStream.reset();
            }
            catch (IOException ioe) {
                printable = false;
            }
        }
        return printable;
    }

    static class BAOutputStream
    extends ByteArrayOutputStream {
        BAOutputStream() {
        }

        BAOutputStream(int size) {
            super(size);
        }

        byte[] getBuffer() {
            return this.buf;
        }
    }
}

