/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.UserIdentityStoreFactory;
import org.jasig.portal.security.IAdditionalDescriptor;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPrincipal;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.PersonDirectory;
import org.jasig.portal.services.StatsRecorder;

public class Authentication {
    protected IPerson m_Person = null;
    protected ISecurityContext ic = null;

    public void authenticate(HashMap principals, HashMap credentials, IPerson person) throws PortalSecurityException {
        ISecurityContext securityContext = person.getSecurityContext();
        Enumeration subCtxNames = securityContext.getSubContextNames();
        this.setContextParameters(principals, credentials, "root", securityContext, person);
        while (subCtxNames.hasMoreElements()) {
            String subCtxName = (String)subCtxNames.nextElement();
            if (subCtxName.equals("root")) continue;
            String subCtxNameWithoutPrefix = subCtxName.startsWith("root.") ? subCtxName.substring(5) : subCtxName;
            ISecurityContext sc = securityContext.getSubContext(subCtxNameWithoutPrefix);
            this.setContextParameters(principals, credentials, subCtxName, sc, person);
        }
        securityContext.authenticate();
        if (securityContext.isAuthenticated()) {
            boolean autocreate;
            String key;
            person.setAttribute("username", securityContext.getPrincipal().getUID());
            IAdditionalDescriptor addInfo = person.getSecurityContext().getAdditionalDescriptor();
            if (addInfo != null) {
                if (addInfo instanceof IPerson) {
                    IPerson newPerson = (IPerson)addInfo;
                    person.setFullName(newPerson.getFullName());
                    Enumeration e = newPerson.getAttributeNames();
                    while (e.hasMoreElements()) {
                        String attributeName = (String)e.nextElement();
                        person.setAttribute(attributeName, newPerson.getAttribute(attributeName));
                    }
                } else if (addInfo instanceof Map) {
                    Map additionalAttributes = (Map)((Object)addInfo);
                    Iterator keys = additionalAttributes.keySet().iterator();
                    while (keys.hasNext()) {
                        key = (String)keys.next();
                        person.setAttribute(key, additionalAttributes.get(key));
                    }
                } else {
                    LogService.log(LogService.WARN, "Authentication Service recieved unknown additional descriptor");
                }
            }
            if (PropertiesManager.getPropertyAsBoolean("org.jasig.portal.services.Authentication.usePersonDirectory")) {
                Hashtable attribs = new PersonDirectory().getUserDirectoryInformation((String)person.getAttribute("username"));
                Enumeration en = attribs.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    person.setAttribute(key, attribs.get(key));
                }
            }
            if (person.getFullName() == null) {
                if (person.getAttribute("portalDisplayName") != null) {
                    person.setFullName((String)person.getAttribute("portalDisplayName"));
                } else if (person.getAttribute("displayName") != null) {
                    person.setFullName((String)person.getAttribute("displayName"));
                }
                if (person.getFullName() == null) {
                    person.setFullName("Unrecognized person: " + person.getAttribute("username"));
                }
            }
            if ((autocreate = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.services.Authentication.autoCreateUsers")) && person.getAttribute("uPortalTemplateUserName") == null) {
                String defaultTemplateUserName = PropertiesManager.getProperty("org.jasig.portal.services.Authentication.defaultTemplateUserName");
                person.setAttribute("uPortalTemplateUserName", defaultTemplateUserName);
            }
            try {
                int newUID = UserIdentityStoreFactory.getUserIdentityStoreImpl().getPortalUID(person, autocreate);
                person.setID(newUID);
            }
            catch (AuthorizationException ae) {
                LogService.log(LogService.ERROR, ae);
                throw new PortalSecurityException("Authentication Service: Exception retrieving UID");
            }
            StatsRecorder.recordLogin(person);
        }
    }

    public IPerson getPerson() {
        return this.m_Person;
    }

    public ISecurityContext getSecurityContext() {
        return this.ic;
    }

    public void setContextParameters(HashMap principals, HashMap credentials, String ctxName, ISecurityContext securityContext, IPerson person) {
        String username = (String)principals.get(ctxName);
        String credential = (String)credentials.get(ctxName);
        username = username != null ? username : (String)principals.get("root");
        credential = credential != null ? credential : (String)credentials.get("root");
        LogService.log(LogService.DEBUG, "Authentication::setContextParameters() username: " + username);
        IPrincipal principalInstance = securityContext.getPrincipalInstance();
        if (username != null && !username.equals("")) {
            principalInstance.setUID(username);
        }
        IOpaqueCredentials credentialsInstance = securityContext.getOpaqueCredentialsInstance();
        credentialsInstance.setCredentials(credential);
    }
}

