/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PersonDirectory {
    static Vector sources = null;
    static Hashtable drivers = new Hashtable();
    public static HashSet propertynames = new HashSet();

    public PersonDirectory() {
        this.getParameters();
    }

    public static Iterator getPropertyNamesIterator() {
        return propertynames.iterator();
    }

    private synchronized boolean getParameters() {
        if (sources != null) {
            return true;
        }
        sources = new Vector();
        try {
            Document doc = ResourceLoader.getResourceAsDocument(this.getClass(), "/properties/PersonDirs.xml");
            NodeList list = doc.getElementsByTagName("PersonDirInfo");
            for (int i = 0; i < list.getLength(); ++i) {
                Element dirinfo = (Element)list.item(i);
                PersonDirInfo pdi = new PersonDirInfo();
                for (Node param = dirinfo.getFirstChild(); param != null; param = param.getNextSibling()) {
                    if (!(param instanceof Element)) continue;
                    Element pele = (Element)param;
                    String tagname = pele.getTagName();
                    String value = this.getTextUnderElement(pele);
                    if (tagname.equals("url")) {
                        pdi.url = value;
                        continue;
                    }
                    if (tagname.equals("res-ref-name")) {
                        pdi.ResRefName = value;
                        continue;
                    }
                    if (tagname.equals("logonid")) {
                        pdi.logonid = value;
                        continue;
                    }
                    if (tagname.equals("driver")) {
                        pdi.driver = value;
                        continue;
                    }
                    if (tagname.equals("logonpassword")) {
                        pdi.logonpassword = value;
                        continue;
                    }
                    if (tagname.equals("uidquery")) {
                        pdi.uidquery = value;
                        continue;
                    }
                    if (tagname.equals("fullnamequery")) {
                        pdi.fullnamequery = value;
                        continue;
                    }
                    if (tagname.equals("usercontext")) {
                        pdi.usercontext = value;
                        continue;
                    }
                    if (tagname.equals("timeout")) {
                        pdi.ldaptimelimit = Integer.parseInt(value);
                        continue;
                    }
                    if (tagname.equals("attributes")) {
                        NodeList anodes = pele.getElementsByTagName("attribute");
                        int anodecount = anodes.getLength();
                        if (anodecount != 0) {
                            pdi.attributenames = new String[anodecount];
                            pdi.attributealiases = new String[anodecount];
                            for (int j = 0; j < anodecount; ++j) {
                                Element anode = (Element)anodes.item(j);
                                NodeList namenodes = anode.getElementsByTagName("name");
                                String aname = "$$$";
                                if (namenodes.getLength() != 0) {
                                    aname = this.getTextUnderElement(namenodes.item(0));
                                }
                                pdi.attributenames[j] = aname;
                                NodeList aliasnodes = anode.getElementsByTagName("alias");
                                pdi.attributealiases[j] = aliasnodes.getLength() == 0 ? aname : this.getTextUnderElement(aliasnodes.item(0));
                            }
                            continue;
                        }
                        StringTokenizer st = new StringTokenizer(value);
                        int n = st.countTokens();
                        pdi.attributenames = new String[n];
                        pdi.attributealiases = new String[n];
                        for (int k = 0; k < n; ++k) {
                            String tk = st.nextToken();
                            int pos = tk.indexOf(58);
                            if (pos > 0) {
                                pdi.attributenames[k] = tk.substring(0, pos);
                                pdi.attributealiases[k] = tk.substring(pos + 1);
                                continue;
                            }
                            pdi.attributenames[k] = tk;
                            pdi.attributealiases[k] = tk;
                        }
                        continue;
                    }
                    LogService.log(LogService.ERROR, "PersonDirectory::getParameters(): Unrecognized tag " + tagname + " in PersonDirs.xml");
                }
                for (int ii = 0; ii < pdi.attributealiases.length; ++ii) {
                    String aa = pdi.attributealiases[ii];
                    propertynames.add(aa);
                }
                sources.addElement(pdi);
            }
        }
        catch (Exception e) {
            sources = null;
            LogService.log(LogService.WARN, "PersonDirectory::getParameters(): properties/PersonDirs.xml is not available, directory searching disabled.");
            return false;
        }
        return true;
    }

    private String getTextUnderElement(Node nele) {
        if (!(nele instanceof Element)) {
            return null;
        }
        Element pele = (Element)nele;
        StringBuffer vb = new StringBuffer();
        NodeList vnodes = pele.getChildNodes();
        for (int j = 0; j < vnodes.getLength(); ++j) {
            Node vnode = vnodes.item(j);
            if (!(vnode instanceof Text)) continue;
            vb.append(((Text)vnode).getData());
        }
        return vb.toString();
    }

    public Hashtable getUserDirectoryInformation(String username) {
        Hashtable attribs = new Hashtable();
        for (int i = 0; i < sources.size(); ++i) {
            PersonDirInfo pdi = (PersonDirInfo)sources.elementAt(i);
            if (pdi.disabled) continue;
            if (pdi.ResRefName != null && pdi.ResRefName.length() > 0) {
                this.processJdbcDir(username, pdi, attribs);
                continue;
            }
            if (pdi.url.startsWith("ldap")) {
                this.processLdapDir(username, pdi, attribs);
                continue;
            }
            if (!pdi.url.startsWith("jdbc:")) continue;
            this.processJdbcDir(username, pdi, attribs);
        }
        return attribs;
    }

    public void getUserDirectoryInformation(String uid, IPerson m_Person) {
        Hashtable attribs = this.getUserDirectoryInformation(uid);
        Enumeration en = attribs.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = null;
            Object tvalue = attribs.get(key);
            if (tvalue instanceof String) {
                value = (String)tvalue;
            }
            if (value == null) continue;
            m_Person.setAttribute(key, value);
        }
    }

    void processLdapDir(String username, PersonDirInfo pdi, Hashtable attribs) {
        Hashtable<String, String> jndienv = new Hashtable<String, String>();
        InitialDirContext context = null;
        jndienv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        jndienv.put("java.naming.security.authentication", "simple");
        if (pdi.url.startsWith("ldaps")) {
            String newurl = pdi.url.substring(0, 4) + pdi.url.substring(5);
            jndienv.put("java.naming.security.protocol", "ssl");
            jndienv.put("java.naming.provider.url", newurl);
        } else {
            jndienv.put("java.naming.provider.url", pdi.url);
        }
        if (pdi.logonid != null) {
            jndienv.put("java.naming.security.principal", pdi.logonid);
        }
        if (pdi.logonpassword != null) {
            jndienv.put("java.naming.security.credentials", pdi.logonpassword);
        }
        try {
            context = new InitialDirContext(jndienv);
        }
        catch (NamingException nex) {
            return;
        }
        NamingEnumeration<SearchResult> userlist = null;
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setTimeLimit(pdi.ldaptimelimit);
        Object[] args = new Object[]{username};
        try {
            userlist = context.search(pdi.usercontext, pdi.uidquery, args, sc);
        }
        catch (NamingException nex) {
            return;
        }
        try {
            if (userlist.hasMoreElements()) {
                SearchResult result = userlist.next();
                Attributes ldapattribs = result.getAttributes();
                for (int i = 0; i < pdi.attributenames.length; ++i) {
                    Attribute tattrib = null;
                    if (pdi.attributenames[i] != null) {
                        tattrib = ldapattribs.get(pdi.attributenames[i]);
                    }
                    if (tattrib == null) continue;
                    Object att = tattrib.get();
                    if (att instanceof byte[]) {
                        attribs.put(pdi.attributealiases[i], att);
                        continue;
                    }
                    String value = att.toString();
                    attribs.put(pdi.attributealiases[i], value);
                }
            }
        }
        catch (NamingException nex) {
            // empty catch block
        }
        try {
            userlist.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            context.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void processJdbcDir(String username, PersonDirInfo pdi, Hashtable attribs) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (pdi.ResRefName != null && pdi.ResRefName.length() > 0) {
                RDBMServices rdbmServices = new RDBMServices();
                conn = RDBMServices.getConnection(pdi.ResRefName);
                LogService.log(LogService.DEBUG, "PersonDirectory::processJdbcDir(): Looking in " + pdi.ResRefName + " for person attributes of " + username);
            }
            if (conn == null) {
                if (pdi.driver != null && pdi.driver.length() > 0 && drivers.get(pdi.driver) == null) {
                    try {
                        Driver driver = (Driver)Class.forName(pdi.driver).newInstance();
                        DriverManager.registerDriver(driver);
                        drivers.put(pdi.driver, driver);
                    }
                    catch (Exception driverproblem) {
                        pdi.disabled = true;
                        pdi.logged = true;
                        LogService.log(LogService.ERROR, "PersonDirectory::processJdbcDir(): Cannot register driver class " + pdi.driver);
                        return;
                    }
                }
                conn = DriverManager.getConnection(pdi.url, pdi.logonid, pdi.logonpassword);
                LogService.log(LogService.DEBUG, "PersonDirectory::processJdbcDir(): Looking in " + pdi.url + " for person attributes of " + username);
            }
            stmt = conn.prepareStatement(pdi.uidquery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (rs.next()) {
                for (int i = 0; i < pdi.attributenames.length; ++i) {
                    try {
                        String value = null;
                        String attName = pdi.attributenames[i];
                        if (attName != null && attName.length() != 0) {
                            value = rs.getString(attName);
                        }
                        if (value == null) continue;
                        attribs.put(pdi.attributealiases[i], value);
                        continue;
                    }
                    catch (SQLException sqle) {
                        LogService.log(LogService.ERROR, "PersonDirectory::processJdbcDir(): Error accessing JDBC field " + pdi.attributenames[i] + " " + sqle);
                    }
                }
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "PersonDirectory::processJdbcDir(): Error " + e);
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private class PersonDirInfo {
        String url;
        String ResRefName;
        String driver;
        String logonid;
        String logonpassword;
        String usercontext;
        String uidquery;
        String fullnamequery;
        int ldaptimelimit = 0;
        String[] attributenames;
        String[] attributealiases;
        boolean disabled = false;
        boolean logged = false;

        private PersonDirInfo() {
        }
    }
}

