/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services.stats;

import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.StatsRecorder;

public class StatsRecorderLayoutEventListener
implements LayoutEventListener {
    IPerson person;
    UserProfile profile;

    public StatsRecorderLayoutEventListener(IPerson person, UserProfile profile) {
        this.person = person;
        this.profile = profile;
    }

    public void channelAdded(LayoutEvent ev) {
        IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
        StatsRecorder.recordChannelAddedToLayout(this.person, this.profile, channelDesc);
    }

    public void channelUpdated(LayoutEvent ev) {
        IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
        StatsRecorder.recordChannelUpdatedInLayout(this.person, this.profile, channelDesc);
    }

    public void channelMoved(LayoutMoveEvent ev) {
        IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
        StatsRecorder.recordChannelMovedInLayout(this.person, this.profile, channelDesc);
    }

    public void channelDeleted(LayoutMoveEvent ev) {
        IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
        StatsRecorder.recordChannelRemovedFromLayout(this.person, this.profile, channelDesc);
    }

    public void folderAdded(LayoutEvent ev) {
        IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
        StatsRecorder.recordFolderAddedToLayout(this.person, this.profile, folderDesc);
    }

    public void folderUpdated(LayoutEvent ev) {
        IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
        StatsRecorder.recordFolderUpdatedInLayout(this.person, this.profile, folderDesc);
    }

    public void folderMoved(LayoutMoveEvent ev) {
        IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
        StatsRecorder.recordFolderMovedInLayout(this.person, this.profile, folderDesc);
    }

    public void folderDeleted(LayoutMoveEvent ev) {
        IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
        StatsRecorder.recordFolderRemovedFromLayout(this.person, this.profile, folderDesc);
    }

    public void layoutLoaded() {
    }

    public void layoutSaved() {
    }
}

