/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.oro.text.perl.Perl5Util;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DbLoader {
    private static URL propertiesURL;
    private static URL tablesURL;
    private static URL dataURL;
    private static String tablesXslUri;
    private static Connection con;
    private static Statement stmt;
    private static PreparedStatement pstmt;
    private static RDBMServices rdbmService;
    private static Document tablesDoc;
    private static Document tablesDocGeneric;
    private static boolean createScript;
    private static boolean dropTables;
    private static boolean createTables;
    private static boolean populateTables;
    private static PrintWriter scriptOut;
    private static String admin_locale;
    private static boolean localeAware;
    private static Hashtable tableColumnTypes;
    static /* synthetic */ Class class$org$jasig$portal$tools$dbloader$DbLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block25: {
            try {
                System.setProperty("org.xml.sax.driver", PropertiesManager.getProperty("org.xml.sax.driver"));
                propertiesURL = (class$org$jasig$portal$tools$dbloader$DbLoader == null ? (class$org$jasig$portal$tools$dbloader$DbLoader = DbLoader.class$("org.jasig.portal.tools.dbloader.DbLoader")) : class$org$jasig$portal$tools$dbloader$DbLoader).getResource("/properties/db/dbloader.xml");
                con = RDBMServices.getConnection();
                if (con != null) {
                    long startTime = System.currentTimeMillis();
                    XMLReader parser = DbLoader.getXMLReader();
                    DbLoader.printInfo();
                    DbLoader.readProperties(parser);
                    dropTables = Boolean.valueOf(PropertiesHandler.properties.getDropTables());
                    createTables = Boolean.valueOf(PropertiesHandler.properties.getCreateTables());
                    populateTables = Boolean.valueOf(PropertiesHandler.properties.getPopulateTables());
                    createScript = Boolean.valueOf(PropertiesHandler.properties.getCreateScript());
                    if (createScript) {
                        DbLoader.initScript();
                    }
                    boolean usetable = false;
                    boolean usedata = false;
                    boolean useLocale = false;
                    for (int i = 0; i < args.length; ++i) {
                        if (!args[i].startsWith("-")) {
                            if (usetable) {
                                PropertiesHandler.properties.setTablesUri(args[i]);
                                usetable = false;
                                continue;
                            }
                            if (usedata) {
                                PropertiesHandler.properties.setDataUri(args[i]);
                                usedata = false;
                                continue;
                            }
                            if (!useLocale) continue;
                            admin_locale = args[i];
                            System.out.println("Using admin locale '" + admin_locale + "'");
                            useLocale = false;
                            continue;
                        }
                        if (args[i].equals("-t")) {
                            usetable = true;
                            continue;
                        }
                        if (args[i].equals("-d")) {
                            usedata = true;
                            continue;
                        }
                        if (args[i].equals("-c")) {
                            createScript = true;
                            continue;
                        }
                        if (args[i].equals("-nc")) {
                            createScript = false;
                            continue;
                        }
                        if (args[i].equals("-D")) {
                            dropTables = true;
                            continue;
                        }
                        if (args[i].equals("-nD")) {
                            dropTables = false;
                            continue;
                        }
                        if (args[i].equals("-C")) {
                            createTables = true;
                            continue;
                        }
                        if (args[i].equals("-nC")) {
                            createTables = false;
                            continue;
                        }
                        if (args[i].equals("-P")) {
                            populateTables = true;
                            continue;
                        }
                        if (args[i].equals("-nP")) {
                            populateTables = false;
                            continue;
                        }
                        if (!args[i].equals("-l")) continue;
                        localeAware = true;
                        useLocale = true;
                    }
                    tablesURL = (class$org$jasig$portal$tools$dbloader$DbLoader == null ? (class$org$jasig$portal$tools$dbloader$DbLoader = DbLoader.class$("org.jasig.portal.tools.dbloader.DbLoader")) : class$org$jasig$portal$tools$dbloader$DbLoader).getResource(PropertiesHandler.properties.getTablesUri());
                    dataURL = (class$org$jasig$portal$tools$dbloader$DbLoader == null ? (class$org$jasig$portal$tools$dbloader$DbLoader = DbLoader.class$("org.jasig.portal.tools.dbloader.DbLoader")) : class$org$jasig$portal$tools$dbloader$DbLoader).getResource(PropertiesHandler.properties.getDataUri());
                    System.out.println("Getting tables from: " + tablesURL);
                    System.out.println("Getting data from: " + dataURL);
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder domParser = dbf.newDocumentBuilder();
                        tablesDoc = domParser.parse(new InputSource(tablesURL.openStream()));
                    }
                    catch (ParserConfigurationException pce) {
                        System.out.println("Unable to instantiate DOM parser. Pease check your JAXP configuration.");
                        pce.printStackTrace();
                    }
                    catch (Exception e) {
                        System.out.println("Could not open " + tablesURL);
                        e.printStackTrace();
                        DbLoader.exit();
                        return;
                    }
                    tablesDocGeneric = (Document)tablesDoc.cloneNode(true);
                    DbLoader.replaceDataTypes(tablesDoc);
                    tablesXslUri = PropertiesHandler.properties.getTablesXslUri();
                    XSLT xslt = XSLT.getTransformer(new DbLoader());
                    xslt.setXML(tablesDoc);
                    xslt.setXSL(tablesXslUri);
                    xslt.setTarget(new TableHandler());
                    xslt.transform();
                    DbLoader.readData(parser);
                    System.out.println("Done!");
                    long endTime = System.currentTimeMillis();
                    System.out.println("Elapsed time: " + (float)(endTime - startTime) / 1000.0f + " seconds");
                    break block25;
                }
                System.out.println("DbLoader couldn't obtain a database connection.  See the portal log for details.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DbLoader.exit();
            }
        }
    }

    private static XMLReader getXMLReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        return spf.newSAXParser().getXMLReader();
    }

    private static void printInfo() throws SQLException {
        DatabaseMetaData dbMetaData = con.getMetaData();
        String dbName = dbMetaData.getDatabaseProductName();
        String dbVersion = dbMetaData.getDatabaseProductVersion();
        String driverName = dbMetaData.getDriverName();
        String driverVersion = dbMetaData.getDriverVersion();
        String driverClass = RDBMServices.getJdbcDriver();
        String url = RDBMServices.getJdbcUrl();
        String user = RDBMServices.getJdbcUser();
        System.out.println("Starting DbLoader...");
        System.out.println("Database name: '" + dbName + "'");
        System.out.println("Database version: '" + dbVersion + "'");
        System.out.println("Driver name: '" + driverName + "'");
        System.out.println("Driver version: '" + driverVersion + "'");
        System.out.println("Driver class: '" + driverClass + "'");
        System.out.println("Connection URL: '" + url + "'");
        System.out.println("User: '" + user + "'");
    }

    private static void readData(XMLReader parser) throws SAXException, IOException {
        InputSource dataInSrc = new InputSource((class$org$jasig$portal$tools$dbloader$DbLoader == null ? (class$org$jasig$portal$tools$dbloader$DbLoader = DbLoader.class$("org.jasig.portal.tools.dbloader.DbLoader")) : class$org$jasig$portal$tools$dbloader$DbLoader).getResourceAsStream(PropertiesHandler.properties.getDataUri()));
        DataHandler dataHandler = new DataHandler();
        parser.setContentHandler(dataHandler);
        parser.setErrorHandler(dataHandler);
        parser.parse(dataInSrc);
    }

    private static void initScript() throws IOException {
        String scriptFileName = PropertiesHandler.properties.getScriptFileName();
        File scriptFile = new File(scriptFileName);
        if (scriptFile.exists()) {
            scriptFile.delete();
        }
        scriptFile.createNewFile();
        scriptOut = new PrintWriter(new BufferedWriter(new FileWriter(scriptFileName, true)));
    }

    private static void replaceDataTypes(Document tablesDoc) {
        Element tables = tablesDoc.getDocumentElement();
        NodeList types = tables.getElementsByTagName("type");
        for (int i = 0; i < types.getLength(); ++i) {
            Node type = types.item(i);
            NodeList typeChildren = type.getChildNodes();
            for (int j = 0; j < typeChildren.getLength(); ++j) {
                Node text = typeChildren.item(j);
                String genericType = text.getNodeValue();
                text.setNodeValue(DbLoader.getLocalDataTypeName(genericType));
            }
        }
    }

    private static int getJavaSqlDataTypeOfColumn(Document tablesDocGeneric, String tableName, String columnName) {
        int dataType = 0;
        String hashKey = tableName + File.separator + columnName;
        if (tableColumnTypes.get(hashKey) != null) {
            dataType = (Integer)tableColumnTypes.get(hashKey);
        } else {
            Element table = DbLoader.getTableWithName(tablesDocGeneric, tableName);
            Element columns = DbLoader.getFirstChildWithName(table, "columns");
            for (Node ch = columns.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
                Element name;
                if (!(ch instanceof Element) || !ch.getNodeName().equals("column") || !DbLoader.getNodeValue(name = DbLoader.getFirstChildWithName((Element)ch, "name")).equals(columnName)) continue;
                Element value = DbLoader.getFirstChildWithName((Element)ch, "type");
                dataType = DbLoader.getJavaSqlType(DbLoader.getNodeValue(value));
            }
            tableColumnTypes.put(hashKey, new Integer(dataType));
        }
        return dataType;
    }

    private static Element getFirstChildWithName(Element parent, String name) {
        Element child = null;
        for (Node ch = parent.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element) || !ch.getNodeName().equals(name)) continue;
            child = (Element)ch;
            break;
        }
        return child;
    }

    private static Element getTableWithName(Document tablesDoc, String tableName) {
        Element tableElement = null;
        NodeList tables = tablesDoc.getElementsByTagName("table");
        block0: for (int i = 0; i < tables.getLength(); ++i) {
            Node table = tables.item(i);
            for (Node tableChild = table.getFirstChild(); tableChild != null; tableChild = tableChild.getNextSibling()) {
                if (!(tableChild instanceof Element) || tableChild.getNodeName() == null || !tableChild.getNodeName().equals("name") || !tableName.equals(DbLoader.getNodeValue(tableChild))) continue;
                tableElement = (Element)table;
                continue block0;
            }
        }
        return tableElement;
    }

    private static String getNodeValue(Node node) {
        String nodeVal = null;
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Text)) continue;
            nodeVal = ch.getNodeValue();
        }
        return nodeVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalDataTypeName(String genericDataTypeName) {
        String localDataTypeName = null;
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            String dbName = dbmd.getDatabaseProductName();
            String dbVersion = dbmd.getDatabaseProductVersion();
            String driverName = dbmd.getDriverName();
            String driverVersion = dbmd.getDriverVersion();
            localDataTypeName = PropertiesHandler.properties.getMappedDataTypeName(dbName, dbVersion, driverName, driverVersion, genericDataTypeName);
            if (localDataTypeName != null) {
                return localDataTypeName;
            }
            int dataTypeCode = DbLoader.getJavaSqlType(genericDataTypeName);
            ResultSet rs = dbmd.getTypeInfo();
            try {
                while (rs.next()) {
                    int localDataTypeCode = rs.getInt("DATA_TYPE");
                    if (dataTypeCode != localDataTypeCode) continue;
                    try {
                        localDataTypeName = rs.getString("TYPE_NAME");
                    }
                    catch (SQLException sqle) {}
                    break;
                }
            }
            finally {
                rs.close();
            }
            if (localDataTypeName != null) {
                return localDataTypeName;
            }
            System.out.println("Your database driver, '" + driverName + "', version '" + driverVersion + "', was unable to find a local type name that matches the generic type name, '" + genericDataTypeName + "'.");
            System.out.println("Please add a mapped type for database '" + dbName + "', version '" + dbVersion + "' inside '" + propertiesURL + "' and run this program again.");
            System.out.println("Exiting...");
            DbLoader.exit();
        }
        catch (Exception e) {
            e.printStackTrace();
            DbLoader.exit();
        }
        return null;
    }

    private static int getJavaSqlType(String genericDataTypeName) {
        int dataTypeCode = 0;
        if (genericDataTypeName.equalsIgnoreCase("BIT")) {
            dataTypeCode = -7;
        } else if (genericDataTypeName.equalsIgnoreCase("TINYINT")) {
            dataTypeCode = -6;
        } else if (genericDataTypeName.equalsIgnoreCase("SMALLINT")) {
            dataTypeCode = 5;
        } else if (genericDataTypeName.equalsIgnoreCase("INTEGER")) {
            dataTypeCode = 4;
        } else if (genericDataTypeName.equalsIgnoreCase("BIGINT")) {
            dataTypeCode = -5;
        } else if (genericDataTypeName.equalsIgnoreCase("FLOAT")) {
            dataTypeCode = 6;
        } else if (genericDataTypeName.equalsIgnoreCase("REAL")) {
            dataTypeCode = 7;
        } else if (genericDataTypeName.equalsIgnoreCase("DOUBLE")) {
            dataTypeCode = 8;
        } else if (genericDataTypeName.equalsIgnoreCase("NUMERIC")) {
            dataTypeCode = 2;
        } else if (genericDataTypeName.equalsIgnoreCase("DECIMAL")) {
            dataTypeCode = 3;
        } else if (genericDataTypeName.equalsIgnoreCase("CHAR")) {
            dataTypeCode = 1;
        } else if (genericDataTypeName.equalsIgnoreCase("VARCHAR")) {
            dataTypeCode = 12;
        } else if (genericDataTypeName.equalsIgnoreCase("LONGVARCHAR")) {
            dataTypeCode = -1;
        } else if (genericDataTypeName.equalsIgnoreCase("DATE")) {
            dataTypeCode = 91;
        } else if (genericDataTypeName.equalsIgnoreCase("TIME")) {
            dataTypeCode = 92;
        } else if (genericDataTypeName.equalsIgnoreCase("TIMESTAMP")) {
            dataTypeCode = 93;
        } else if (genericDataTypeName.equalsIgnoreCase("BINARY")) {
            dataTypeCode = -2;
        } else if (genericDataTypeName.equalsIgnoreCase("VARBINARY")) {
            dataTypeCode = -3;
        } else if (genericDataTypeName.equalsIgnoreCase("LONGVARBINARY")) {
            dataTypeCode = -4;
        } else if (genericDataTypeName.equalsIgnoreCase("NULL")) {
            dataTypeCode = 0;
        } else if (genericDataTypeName.equalsIgnoreCase("OTHER")) {
            dataTypeCode = 1111;
        } else if (genericDataTypeName.equalsIgnoreCase("JAVA_OBJECT")) {
            dataTypeCode = 2000;
        } else if (genericDataTypeName.equalsIgnoreCase("DISTINCT")) {
            dataTypeCode = 2001;
        } else if (genericDataTypeName.equalsIgnoreCase("STRUCT")) {
            dataTypeCode = 2002;
        } else if (genericDataTypeName.equalsIgnoreCase("ARRAY")) {
            dataTypeCode = 2003;
        } else if (genericDataTypeName.equalsIgnoreCase("BLOB")) {
            dataTypeCode = 2004;
        } else if (genericDataTypeName.equalsIgnoreCase("CLOB")) {
            dataTypeCode = 2005;
        } else if (genericDataTypeName.equalsIgnoreCase("REF")) {
            dataTypeCode = 2006;
        }
        return dataTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTable(String dropTableStatement) {
        System.out.print("...");
        if (createScript) {
            scriptOut.println(dropTableStatement + PropertiesHandler.properties.getStatementTerminator());
        }
        try {
            stmt = con.createStatement();
            try {
                stmt.executeUpdate(dropTableStatement);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTable(String createTableStatement) {
        System.out.print("...");
        if (createScript) {
            scriptOut.println(createTableStatement + PropertiesHandler.properties.getStatementTerminator());
        }
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(createTableStatement);
        }
        catch (Exception e) {
            System.out.println(createTableStatement);
            e.printStackTrace();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void readProperties(XMLReader parser) throws SAXException, IOException {
        PropertiesHandler propertiesHandler = new PropertiesHandler();
        parser.setContentHandler(propertiesHandler);
        parser.setErrorHandler(propertiesHandler);
        parser.parse(new InputSource(propertiesURL.openStream()));
    }

    private static void exit() {
        RDBMServices.releaseConnection(con);
        if (scriptOut != null) {
            scriptOut.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tableColumnTypes = new Hashtable(300);
    }

    static class DataHandler
    extends DefaultHandler {
        private static StringBuffer charBuff = null;
        private static boolean insideData = false;
        private static boolean insideTable = false;
        private static boolean insideName = false;
        private static boolean insideRow = false;
        private static boolean insideColumn = false;
        private static boolean insideValue = false;
        private static boolean supportsPreparedStatements = false;
        static Table table;
        static Row row;
        static Column column;
        static String action;
        static String type;

        DataHandler() {
        }

        public void startDocument() {
            System.out.print("Populating tables...");
            if (!populateTables) {
                System.out.print("disabled.");
            }
            supportsPreparedStatements = DataHandler.supportsPreparedStatements();
        }

        public void endDocument() {
            System.out.println("");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            charBuff = new StringBuffer();
            if (qName.equals("data")) {
                insideData = true;
            } else if (qName.equals("table")) {
                insideTable = true;
                table = new Table();
                action = atts.getValue("action");
            } else if (qName.equals("name")) {
                insideName = true;
            } else if (qName.equals("row")) {
                insideRow = true;
                row = new Row();
            } else if (qName.equals("column")) {
                insideColumn = true;
                column = new Column();
                type = atts.getValue("type");
            } else if (qName.equals("value")) {
                insideValue = true;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("data")) {
                insideData = false;
            } else if (qName.equals("table")) {
                insideTable = false;
            } else if (qName.equals("name")) {
                insideName = false;
                if (!insideColumn) {
                    table.setName(charBuff.toString());
                } else {
                    column.setName(charBuff.toString());
                }
            } else if (qName.equals("row")) {
                insideRow = false;
                if (action != null) {
                    if (action.equals("delete")) {
                        this.executeSQL(table, row, "delete");
                    } else if (action.equals("modify")) {
                        this.executeSQL(table, row, "modify");
                    } else if (action.equals("add")) {
                        this.executeSQL(table, row, "insert");
                    }
                } else if (populateTables) {
                    this.executeSQL(table, row, "insert");
                }
            } else if (qName.equals("column")) {
                insideColumn = false;
                if (type != null) {
                    column.setType(type);
                }
                row.addColumn(column);
            } else if (qName.equals("value")) {
                insideValue = false;
                if (insideColumn) {
                    column.setValue(charBuff.toString());
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            charBuff.append(ch, start, length);
        }

        private String prepareInsertStatement(Row row, boolean preparedStatement) {
            Column column;
            StringBuffer sb = new StringBuffer("INSERT INTO ");
            sb.append(table.getName()).append(" (");
            ArrayList columns = row.getColumns();
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                column = (Column)iterator.next();
                sb.append(column.getName()).append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") VALUES (");
            iterator = columns.iterator();
            while (iterator.hasNext()) {
                column = (Column)iterator.next();
                if (preparedStatement) {
                    sb.append("?");
                } else {
                    String value = column.getValue();
                    if (value != null) {
                        if (value.equals("SYSDATE")) {
                            sb.append(value);
                        } else if (value.equals("NULL")) {
                            sb.append(value);
                        } else if (DbLoader.getJavaSqlDataTypeOfColumn(tablesDocGeneric, DataHandler.table.getName(), column.getName()) == 4) {
                            sb.append(value);
                        } else {
                            sb.append("'");
                            sb.append(DataHandler.sqlEscape(value.trim()));
                            sb.append("'");
                        }
                    } else {
                        sb.append("''");
                    }
                }
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }

        private String prepareDeleteStatement(Row row, boolean preparedStatement) {
            StringBuffer sb = new StringBuffer("DELETE FROM ");
            sb.append(table.getName()).append(" WHERE ");
            ArrayList columns = row.getColumns();
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                if (preparedStatement) {
                    sb.append(column.getName() + " = ? and ");
                    continue;
                }
                if (DbLoader.getJavaSqlDataTypeOfColumn(tablesDocGeneric, DataHandler.table.getName(), column.getName()) == 4) {
                    sb.append(column.getName() + " = " + DataHandler.sqlEscape(column.getValue().trim()) + " and ");
                    continue;
                }
                sb.append(column.getName() + " = " + "'" + DataHandler.sqlEscape(column.getValue().trim()) + "' and ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            if (!preparedStatement) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        private String prepareUpdateStatement(Row row, boolean preparedStatement) {
            String val;
            String nm;
            StringBuffer sb = new StringBuffer("UPDATE ");
            sb.append(table.getName()).append(" SET ");
            ArrayList columns = row.getColumns();
            Iterator iterator = columns.iterator();
            Hashtable<String, String> setPairs = new Hashtable<String, String>();
            Hashtable<String, String> wherePairs = new Hashtable<String, String>();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                String type = column.getType();
                if (type != null && type.equals("select")) {
                    if (DbLoader.getJavaSqlDataTypeOfColumn(tablesDocGeneric, DataHandler.table.getName(), column.getName()) == 4) {
                        wherePairs.put(column.getName(), column.getValue().trim());
                        continue;
                    }
                    wherePairs.put(column.getName(), "'" + column.getValue().trim() + "'");
                    continue;
                }
                if (DbLoader.getJavaSqlDataTypeOfColumn(tablesDocGeneric, DataHandler.table.getName(), column.getName()) == 4) {
                    setPairs.put(column.getName(), column.getValue().trim());
                    continue;
                }
                setPairs.put(column.getName(), "'" + column.getValue().trim() + "'");
            }
            Enumeration sKeys = setPairs.keys();
            while (sKeys.hasMoreElements()) {
                nm = (String)sKeys.nextElement();
                val = (String)setPairs.get(nm);
                sb.append(nm + " = " + DataHandler.sqlEscape(val) + ", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" WHERE ");
            Enumeration wKeys = wherePairs.keys();
            while (wKeys.hasMoreElements()) {
                nm = (String)wKeys.nextElement();
                val = (String)wherePairs.get(nm);
                sb.append(nm + "=" + DataHandler.sqlEscape(val) + " and ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        public static final String sqlEscape(String sql) {
            if (sql == null) {
                return "";
            }
            int primePos = sql.indexOf("'");
            if (primePos == -1) {
                return sql;
            }
            StringBuffer sb = new StringBuffer(sql.length() + 4);
            int startPos = 0;
            do {
                sb.append(sql.substring(startPos, primePos + 1));
                sb.append("'");
            } while ((primePos = sql.indexOf("'", startPos = primePos + 1)) != -1);
            sb.append(sql.substring(startPos));
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeSQL(Table table, Row row, String action) {
            System.out.print("...");
            if (createScript) {
                if (action.equals("delete")) {
                    scriptOut.println(this.prepareDeleteStatement(row, false) + PropertiesHandler.properties.getStatementTerminator());
                } else if (action.equals("modify")) {
                    scriptOut.println(this.prepareUpdateStatement(row, false) + PropertiesHandler.properties.getStatementTerminator());
                } else if (action.equals("insert")) {
                    scriptOut.println(this.prepareInsertStatement(row, false) + PropertiesHandler.properties.getStatementTerminator());
                }
            }
            if (supportsPreparedStatements) {
                String preparedStatement = "";
                try {
                    if (action.equals("delete")) {
                        preparedStatement = this.prepareDeleteStatement(row, true);
                    } else if (action.equals("modify")) {
                        preparedStatement = this.prepareUpdateStatement(row, true);
                    } else if (action.equals("insert")) {
                        preparedStatement = this.prepareInsertStatement(row, true);
                    }
                    pstmt = con.prepareStatement(preparedStatement);
                    pstmt.clearParameters();
                    ArrayList columns = row.getColumns();
                    Iterator iterator = columns.iterator();
                    int i = 1;
                    while (iterator.hasNext()) {
                        Column column = (Column)iterator.next();
                        String value = column.getValue();
                        int javaSqlDataType = DbLoader.getJavaSqlDataTypeOfColumn(tablesDocGeneric, table.getName(), column.getName());
                        if (value == null || value != null && value.equalsIgnoreCase("NULL")) {
                            pstmt.setNull(i, javaSqlDataType);
                        } else if (javaSqlDataType == 93) {
                            if (value.equals("SYSDATE")) {
                                pstmt.setTimestamp(i, new Timestamp(System.currentTimeMillis()));
                            } else {
                                pstmt.setTimestamp(i, Timestamp.valueOf(value));
                            }
                        } else {
                            int valueLength = (value = value.trim()).length();
                            if (valueLength <= 4000) {
                                try {
                                    pstmt.setObject(i, (Object)value, javaSqlDataType);
                                }
                                catch (Exception e) {
                                    pstmt.setObject(i, value);
                                }
                            } else {
                                try {
                                    try {
                                        pstmt.setObject(i, (Object)value, javaSqlDataType);
                                    }
                                    catch (Exception e) {
                                        pstmt.setObject(i, value);
                                    }
                                }
                                catch (SQLException sqle) {
                                    pstmt.setCharacterStream(i, (Reader)new StringReader(value), valueLength);
                                }
                            }
                        }
                        ++i;
                    }
                    pstmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    System.err.println();
                    System.err.println(preparedStatement);
                    sqle.printStackTrace();
                }
                catch (Exception e) {
                    System.err.println();
                    e.printStackTrace();
                }
                finally {
                    try {
                        pstmt.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                String statement = "";
                if (action.equals("delete")) {
                    statement = this.prepareDeleteStatement(row, false);
                } else if (action.equals("modify")) {
                    statement = this.prepareUpdateStatement(row, false);
                } else if (action.equals("insert")) {
                    statement = this.prepareInsertStatement(row, false);
                }
                try {
                    stmt = con.createStatement();
                    stmt.executeUpdate(statement);
                }
                catch (Exception e) {
                    System.err.println();
                    System.err.println(statement);
                    e.printStackTrace();
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private static boolean supportsPreparedStatements() {
            boolean supportsPreparedStatements;
            block48: {
                supportsPreparedStatements = true;
                Statement stmt = con.createStatement();
                try {
                    stmt.executeUpdate("CREATE TABLE PREP_TEST (A VARCHAR(1))");
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
                pstmt = con.prepareStatement("SELECT A FROM PREP_TEST WHERE A=?");
                pstmt.clearParameters();
                pstmt.setString(1, "D");
                ResultSet rs = pstmt.executeQuery();
                rs.close();
                Object var6_9 = null;
                try {
                    stmt = con.createStatement();
                    stmt.executeUpdate("DROP TABLE PREP_TEST");
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    pstmt.close();
                }
                catch (Exception e) {}
                break block48;
                {
                    catch (SQLException sqle) {
                        supportsPreparedStatements = false;
                        sqle.printStackTrace();
                        Object var6_10 = null;
                        try {
                            stmt = con.createStatement();
                            stmt.executeUpdate("DROP TABLE PREP_TEST");
                        }
                        catch (Exception e) {
                        }
                        finally {
                            try {
                                stmt.close();
                            }
                            catch (Exception e) {}
                        }
                        try {
                            pstmt.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    try {
                        stmt = con.createStatement();
                        stmt.executeUpdate("DROP TABLE PREP_TEST");
                    }
                    catch (Exception e) {
                    }
                    finally {
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {}
                    }
                    try {
                        pstmt.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return supportsPreparedStatements;
        }

        class Column {
            private String name;
            private String value;
            private String type;

            Column() {
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public String getType() {
                return this.type;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public void setType(String type) {
                this.type = type;
            }
        }

        class Row {
            ArrayList columns = new ArrayList();

            Row() {
            }

            public ArrayList getColumns() {
                return this.columns;
            }

            public void addColumn(Column column) {
                this.columns.add(column);
            }
        }

        class Table {
            private String name;

            Table() {
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    static class TableHandler
    implements ContentHandler {
        private static final int UNSET = -1;
        private static final int DROP = 0;
        private static final int CREATE = 1;
        private static int mode = -1;
        private static StringBuffer stmtBuffer;

        TableHandler() {
        }

        public void startDocument() {
        }

        public void endDocument() {
            System.out.println();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (qName.equals("statement")) {
                stmtBuffer = new StringBuffer(1024);
                String statementType = atts.getValue("type");
                if (mode == -1 || mode == 1 && statementType != null && statementType.equals("drop")) {
                    mode = 0;
                    System.out.print("Dropping tables...");
                    if (!dropTables) {
                        System.out.print("disabled.");
                    }
                } else if (mode == -1 || mode == 0 && statementType != null && statementType.equals("create")) {
                    mode = 1;
                    System.out.print("\nCreating tables...");
                    if (!createTables) {
                        System.out.print("disabled.");
                    }
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("statement")) {
                String statement = stmtBuffer.toString();
                switch (mode) {
                    case 0: {
                        if (!dropTables) break;
                        DbLoader.dropTable(statement);
                        break;
                    }
                    case 1: {
                        if (!createTables) break;
                        DbLoader.createTable(statement);
                        break;
                    }
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            stmtBuffer.append(ch, start, length);
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }

    static class PropertiesHandler
    extends DefaultHandler {
        private static StringBuffer charBuff = null;
        static Properties properties;
        static DbTypeMapping dbTypeMapping;
        static Type type;

        PropertiesHandler() {
        }

        public void startDocument() {
            System.out.print("Parsing " + propertiesURL + "...");
        }

        public void endDocument() {
            System.out.println("");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            charBuff = new StringBuffer();
            if (qName.equals("properties")) {
                properties = new Properties();
            } else if (qName.equals("db-type-mapping")) {
                dbTypeMapping = new DbTypeMapping();
            } else if (qName.equals("type")) {
                type = new Type();
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("drop-tables")) {
                properties.setDropTables(charBuff.toString());
            } else if (qName.equals("create-tables")) {
                properties.setCreateTables(charBuff.toString());
            } else if (qName.equals("populate-tables")) {
                properties.setPopulateTables(charBuff.toString());
            } else if (qName.equals("tables-uri")) {
                properties.setTablesUri(charBuff.toString());
            } else if (qName.equals("tables-xsl-uri")) {
                properties.setTablesXslUri(charBuff.toString());
            } else if (qName.equals("data-uri")) {
                properties.setDataUri(charBuff.toString());
            } else if (qName.equals("create-script")) {
                properties.setCreateScript(charBuff.toString());
            } else if (qName.equals("script-file-name")) {
                properties.setScriptFileName(charBuff.toString());
            } else if (qName.equals("statement-terminator")) {
                properties.setStatementTerminator(charBuff.toString());
            } else if (qName.equals("db-type-mapping")) {
                properties.addDbTypeMapping(dbTypeMapping);
            } else if (qName.equals("db-name")) {
                dbTypeMapping.setDbName(charBuff.toString());
            } else if (qName.equals("db-version")) {
                dbTypeMapping.setDbVersion(charBuff.toString());
            } else if (qName.equals("driver-name")) {
                dbTypeMapping.setDriverName(charBuff.toString());
            } else if (qName.equals("driver-version")) {
                dbTypeMapping.setDriverVersion(charBuff.toString());
            } else if (qName.equals("type")) {
                dbTypeMapping.addType(type);
            } else if (qName.equals("generic")) {
                type.setGeneric(charBuff.toString());
            } else if (qName.equals("local")) {
                type.setLocal(charBuff.toString());
            }
        }

        public void characters(char[] ch, int start, int length) {
            charBuff.append(ch, start, length);
        }

        class Type {
            String genericType;
            String local;

            Type() {
            }

            public String getGeneric() {
                return this.genericType;
            }

            public String getLocal() {
                return this.local;
            }

            public void setGeneric(String genericType) {
                this.genericType = genericType;
            }

            public void setLocal(String local) {
                this.local = local;
            }
        }

        class DbTypeMapping {
            String dbName;
            String dbVersion;
            String driverName;
            String driverVersion;
            ArrayList types = new ArrayList();

            DbTypeMapping() {
            }

            public String getDbName() {
                return this.dbName;
            }

            public String getDbVersion() {
                return this.dbVersion;
            }

            public String getDriverName() {
                return this.driverName;
            }

            public String getDriverVersion() {
                return this.driverVersion;
            }

            public ArrayList getTypes() {
                return this.types;
            }

            public void setDbName(String dbName) {
                this.dbName = dbName;
            }

            public void setDbVersion(String dbVersion) {
                this.dbVersion = dbVersion;
            }

            public void setDriverName(String driverName) {
                this.driverName = driverName;
            }

            public void setDriverVersion(String driverVersion) {
                this.driverVersion = driverVersion;
            }

            public void addType(Type type) {
                this.types.add(type);
            }

            public String getMappedDataTypeName(String genericDataTypeName) {
                String mappedDataTypeName = null;
                Iterator iterator = this.types.iterator();
                while (iterator.hasNext()) {
                    Type type = (Type)iterator.next();
                    if (!type.getGeneric().equalsIgnoreCase(genericDataTypeName)) continue;
                    mappedDataTypeName = type.getLocal();
                }
                return mappedDataTypeName;
            }
        }

        class Properties {
            private String dropTables;
            private String createTables;
            private String populateTables;
            private String tablesUri;
            private String tablesXslUri;
            private String dataUri;
            private String dataXslUri;
            private String createScript;
            private String scriptFileName;
            private String statementTerminator;
            private ArrayList dbTypeMappings = new ArrayList();

            Properties() {
            }

            public String getDropTables() {
                return this.dropTables;
            }

            public String getCreateTables() {
                return this.createTables;
            }

            public String getPopulateTables() {
                return this.populateTables;
            }

            public String getTablesUri() {
                return this.tablesUri;
            }

            public String getTablesXslUri() {
                return this.tablesXslUri;
            }

            public String getDataUri() {
                String ret = this.dataUri;
                if (localeAware && admin_locale != null) {
                    Perl5Util perl5Util = new Perl5Util();
                    ret = perl5Util.substitute("s/\\.xml/_" + admin_locale + ".xml" + "/g", ret);
                }
                return ret;
            }

            public String getDataXslUri() {
                return this.dataXslUri;
            }

            public String getCreateScript() {
                return this.createScript;
            }

            public String getScriptFileName() {
                return this.scriptFileName;
            }

            public String getStatementTerminator() {
                return this.statementTerminator;
            }

            public ArrayList getDbTypeMappings() {
                return this.dbTypeMappings;
            }

            public void setDropTables(String dropTables) {
                this.dropTables = dropTables;
            }

            public void setCreateTables(String createTables) {
                this.createTables = createTables;
            }

            public void setPopulateTables(String populateTables) {
                this.populateTables = populateTables;
            }

            public void setTablesUri(String tablesUri) {
                this.tablesUri = tablesUri;
            }

            public void setTablesXslUri(String tablesXslUri) {
                this.tablesXslUri = tablesXslUri;
            }

            public void setDataUri(String dataUri) {
                this.dataUri = dataUri;
            }

            public void setDataXslUri(String dataXslUri) {
                this.dataXslUri = dataXslUri;
            }

            public void setCreateScript(String createScript) {
                this.createScript = createScript;
            }

            public void setScriptFileName(String scriptFileName) {
                this.scriptFileName = scriptFileName;
            }

            public void setStatementTerminator(String statementTerminator) {
                this.statementTerminator = statementTerminator;
            }

            public void addDbTypeMapping(DbTypeMapping dbTypeMapping) {
                this.dbTypeMappings.add(dbTypeMapping);
            }

            public String getMappedDataTypeName(String dbName, String dbVersion, String driverName, String driverVersion, String genericDataTypeName) {
                String mappedDataTypeName = null;
                Iterator iterator = this.dbTypeMappings.iterator();
                while (iterator.hasNext()) {
                    DbTypeMapping dbTypeMapping = (DbTypeMapping)iterator.next();
                    String dbNameProp = dbTypeMapping.getDbName();
                    String dbVersionProp = dbTypeMapping.getDbVersion();
                    String driverNameProp = dbTypeMapping.getDriverName();
                    String driverVersionProp = dbTypeMapping.getDriverVersion();
                    if (!dbNameProp.equalsIgnoreCase(dbName) || !dbVersionProp.equalsIgnoreCase(dbVersion) || !driverNameProp.equalsIgnoreCase(driverName) || !driverVersionProp.equalsIgnoreCase(driverVersion)) continue;
                    mappedDataTypeName = dbTypeMapping.getMappedDataTypeName(genericDataTypeName);
                }
                return mappedDataTypeName;
            }
        }
    }
}

