/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.utils.ICounterStore;

public class CounterStoreFactory {
    private static ICounterStore counterStoreImpl = null;

    public static ICounterStore getCounterStoreImpl() throws PortalException {
        if (counterStoreImpl == null) {
            CounterStoreFactory.initialize();
        }
        return counterStoreImpl;
    }

    private static void initialize() throws PortalException {
        String className = PropertiesManager.getProperty("org.jasig.portal.utils.CounterStoreFactory.implementation");
        if (className == null) {
            throw new PortalException("CounterStoreFactory: org.jasig.portal.utils.CounterStoreFactory.implementation must be specified in portal.properties");
        }
        try {
            counterStoreImpl = (ICounterStore)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new PortalException("CounterStoreFactory: Could not instantiate " + className, e);
        }
    }
}

