/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.net.InetAddress;
import java.util.Random;
import sun.io.ByteToCharConverter;

public class GuidGenerator {
    private static final short CLOCKMOD = 16384;
    private static final short NANOS = 10000;
    private static long nanoCounter = 0L;
    private static String clockSeq;
    private static long lastMilliTime;
    private String macbase;
    private String timebase;
    private static Random random;

    public GuidGenerator() throws Exception {
        InetAddress ip = InetAddress.getByName(InetAddress.getLocalHost().getHostName());
        byte[] bytes = ip.getAddress();
        StringBuffer buffer = new StringBuffer(12);
        buffer.append(new String(bytes));
        int actualSize = buffer.toString().length();
        if (actualSize < 12) {
            byte[] tailBytes = new byte[12 - actualSize];
            random.nextBytes(tailBytes);
            ByteToCharConverter converter = ByteToCharConverter.getConverter((String)"ASCII");
            char[] tailChars = converter.convertAll(tailBytes);
            buffer.append(tailChars);
        }
        this.initGuid(buffer.toString());
    }

    public GuidGenerator(String newMAC) throws IllegalArgumentException {
        this.initGuid(newMAC);
    }

    private void initGuid(String newMAC) throws IllegalArgumentException {
        if (newMAC.length() != 12 && newMAC.trim().length() != 12) {
            throw new IllegalArgumentException("Guid(String) requires 12-digit string per RFC");
        }
        GuidGenerator.setLastTime(GuidGenerator.getMilliTime());
        GuidGenerator.setClockSeq();
        this.macbase = newMAC;
        this.set();
    }

    static synchronized long getNano() {
        GuidGenerator.nanoBump();
        return nanoCounter;
    }

    static synchronized void nanoBump() {
        ++nanoCounter;
    }

    static synchronized void nanoReset() {
        nanoCounter = 0L;
    }

    static synchronized long getLastTime() {
        return lastMilliTime;
    }

    static synchronized void setLastTime(long lastTime) {
        lastMilliTime = lastTime;
    }

    static synchronized long getMilliTime() {
        return System.currentTimeMillis() * 10000L;
    }

    static synchronized String getClockSeq() {
        return clockSeq;
    }

    static synchronized void setClockSeq() {
        short x00FF = new Integer(255).shortValue();
        short x3F00 = new Integer(16128).shortValue();
        short x0080 = new Integer(128).shortValue();
        String tempclockseq = "";
        short clockCounter = new Double(Math.random() * 16384.0).shortValue();
        int sbfr = clockCounter & x00FF;
        byte clock_seq_low = new Short(new Integer(sbfr).shortValue()).byteValue();
        sbfr = (clockCounter & x3F00) >> 10;
        byte clock_seq_hi_res = new Short(new Integer(sbfr).shortValue()).byteValue();
        clock_seq_hi_res = (byte)(clock_seq_hi_res | new Short(new Integer(x0080).shortValue()).byteValue());
        sbfr = clock_seq_hi_res;
        sbfr <<= 8;
        tempclockseq = Integer.toHexString(sbfr |= clock_seq_low);
        int tlen = tempclockseq.length();
        clockSeq = tempclockseq.substring(Math.max(tlen - 4, 0), tlen);
    }

    public String getNewGuid() {
        this.set();
        return this.toString();
    }

    public String toString() {
        return this.timebase + "-" + this.macbase;
    }

    public void set() {
        long lastmilli;
        long nanomod = 0L;
        String temptimemid = "";
        String temptimehi = "";
        long millitime = GuidGenerator.getMilliTime();
        if (millitime == (lastmilli = GuidGenerator.getLastTime())) {
            nanomod = GuidGenerator.getNano();
            millitime += nanomod;
        } else {
            GuidGenerator.nanoReset();
        }
        long lbfr = millitime & 0xFFFFFFFFL;
        int time_low = new Long(lbfr).intValue();
        lbfr = (millitime & 0xFFFFFFFF00000000L) >>> 32;
        int time_hi = new Long(lbfr).intValue();
        int ibfr = time_hi & 0xFFFF;
        short time_mid = new Integer(ibfr).shortValue();
        ibfr = (time_hi & 0xFFF0000) >>> 16;
        short time_hi_ver = new Integer(ibfr).shortValue();
        time_hi_ver = (short)(time_hi_ver | 0x4000);
        temptimemid = Integer.toHexString(time_mid);
        int tlen = temptimemid.length();
        temptimemid = temptimemid.substring(Math.max(tlen - 4, 0), tlen);
        temptimehi = Integer.toHexString(time_hi_ver);
        tlen = temptimehi.length();
        temptimehi = temptimehi.substring(Math.max(tlen - 4, 0), tlen);
        this.timebase = Integer.toHexString(time_low) + "-" + temptimemid + "-" + temptimehi + "-" + GuidGenerator.getClockSeq();
        GuidGenerator.setLastTime(millitime - nanomod);
    }

    public static void main(String[] args) {
        try {
            GuidGenerator g = new GuidGenerator("abcdefghijkl");
            System.out.println("New GUID is " + g.getNewGuid());
            g = new GuidGenerator();
            System.out.println("New GUID is " + g.getNewGuid());
        }
        catch (Exception e) {
            System.out.println("GuidGenerator::main threw " + e.getClass() + " with message: " + e.getMessage());
        }
    }

    static {
        random = new Random();
    }
}

