/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class PropsMatcher {
    Vector patterns;
    Vector ids;
    PatternMatcher matcher;

    public PropsMatcher(InputStream is) throws IOException {
        Perl5Compiler compiler = new Perl5Compiler();
        this.matcher = new Perl5Matcher();
        Vector v = this.readPropertiesVector(is);
        this.patterns = new Vector();
        this.ids = new Vector(v.size());
        for (int i = 0; i < v.size(); ++i) {
            String[] temp = (String[])v.elementAt(i);
            try {
                Pattern p = compiler.compile(temp[0]);
                this.patterns.addElement(p);
                this.ids.addElement(temp[1]);
                continue;
            }
            catch (MalformedPatternException mpe) {
                System.out.println("PropsMatcher::PropsMatcher() : invalid pattern: " + temp[0]);
                System.out.println("PropsMatcher::PropsMatcher() : " + mpe.getMessage());
            }
        }
    }

    public String match(String input) {
        for (int i = 0; i < this.patterns.size(); ++i) {
            if (!this.matcher.matches(input, (Pattern)this.patterns.elementAt(i))) continue;
            return (String)this.ids.elementAt(i);
        }
        return null;
    }

    private Vector readPropertiesVector(InputStream inputStream) throws IOException {
        String currentLine;
        Vector<String[]> v = new Vector<String[]>(10);
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
        String Key2 = null;
        while ((currentLine = input.readLine()) != null) {
            StringTokenizer currentTokens = new StringTokenizer(currentLine, "=\t\r\n");
            if (currentTokens.hasMoreTokens()) {
                Key2 = currentTokens.nextToken().trim();
            }
            if (Key2 == null || Key2.startsWith("#") || !currentTokens.hasMoreTokens()) continue;
            String[] temp = new String[]{Key2, currentTokens.nextToken().trim()};
            v.addElement(temp);
        }
        return v;
    }
}

