/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class SoftHashMap
extends AbstractMap {
    private final HashMap map = new HashMap();
    private final LinkedList fifo = new LinkedList();
    private final ReferenceQueue removeQueue = new ReferenceQueue();
    private int minSize;
    private int maxSize;

    public SoftHashMap(int minSize) {
        this.minSize = minSize;
    }

    public SoftHashMap() {
        this(10);
    }

    public Object put(Object key, Object value) {
        this.cleanMap();
        KeyReferencePair pair = new KeyReferencePair(value, key, this.removeQueue);
        this.addToFIFO(value);
        return this.map.put(key, pair);
    }

    public Object get(Object key) {
        SoftReference soft_ref = (SoftReference)this.map.get(key);
        if (soft_ref != null) {
            Object obj = soft_ref.get();
            if (obj == null) {
                this.map.remove(key);
            } else {
                this.addToFIFO(obj);
            }
            return obj;
        }
        return null;
    }

    public Object remove(Object key) {
        this.cleanMap();
        SoftReference soft_ref = (SoftReference)this.map.remove(key);
        if (soft_ref != null) {
            return soft_ref.get();
        }
        return null;
    }

    public int size() {
        this.cleanMap();
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.fifo;
        synchronized (linkedList) {
            this.fifo.clear();
        }
        this.map.clear();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFIFO(Object o) {
        LinkedList linkedList = this.fifo;
        synchronized (linkedList) {
            this.fifo.addFirst(o);
            if (this.fifo.size() > this.minSize) {
                this.fifo.removeLast();
            }
        }
    }

    private void cleanMap() {
        KeyReferencePair pair;
        while ((pair = (KeyReferencePair)this.removeQueue.poll()) != null) {
            this.map.remove(pair.key);
        }
    }

    private static final class KeyReferencePair
    extends SoftReference {
        private final Object key;

        public KeyReferencePair(Object value, Object key, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

