/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.sql.Connection;
import java.sql.SQLException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.LogService;

public class SqlTransaction {
    public static void begin(Connection conn) throws SQLException {
        try {
            RDBMServices.setAutoCommit(conn, false);
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    public static void commit(Connection conn) throws SQLException {
        try {
            RDBMServices.commit(conn);
            RDBMServices.setAutoCommit(conn, true);
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    protected static void logNoTransactionWarning() {
        String msg = "You are running the portal on a database that does not support transactions.  This is not a supported production environment for uPortal.  Sooner or later, your database will become corrupt.";
        LogService.log(LogService.WARN, msg);
    }

    public static void rollback(Connection conn) throws SQLException {
        try {
            RDBMServices.rollback(conn);
            RDBMServices.setAutoCommit(conn, true);
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    public static void setAutoCommit(Connection conn, boolean newValue) throws SQLException {
        try {
            RDBMServices.setAutoCommit(conn, newValue);
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }
}

