/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import java.util.Vector;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.threading.Queue;
import org.jasig.portal.utils.threading.ThreadPool;
import org.jasig.portal.utils.threading.UnboundedQueue;
import org.jasig.portal.utils.threading.WorkTracker;
import org.jasig.portal.utils.threading.WorkerTask;

public abstract class AbstractPool
implements ThreadPool {
    protected int priority;
    protected boolean isDestroyed = false;
    private Vector busyThreads;
    private Vector idleThreads = new Vector();
    protected int minThreads;
    protected int maxThreads;
    private long DELAY = 200L;
    protected Queue workQueue;
    private static int counter = 0;

    public AbstractPool(int minThreads, int maxThreads, int threadPriority) {
        this.busyThreads = new Vector();
        this.workQueue = new UnboundedQueue();
        this.maxThreads = maxThreads;
        this.minThreads = minThreads;
        this.priority = threadPriority;
        try {
            this.initThreadPool();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void initThreadPool() throws Exception {
        LogService.log(LogService.DEBUG, "AbstractPool.initThreadPool() starting");
        for (int i = 0; i < this.minThreads; ++i) {
            Thread thread = this.createNewThread();
            this.idleThreads.add(thread);
            thread.start();
        }
        LogService.log(LogService.DEBUG, "AbstractPool.initThreadPool() ending");
    }

    protected synchronized void adjustThreadPool() throws Exception {
        if (this.idleThreads() == 0 && this.busyThreads() < this.maxThreads) {
            Thread thread = this.createNewThread();
            this.idleThreads.add(thread);
            thread.start();
        }
    }

    public abstract WorkTracker execute(WorkerTask var1) throws IllegalStateException;

    protected abstract Thread createNewThread() throws Exception;

    public abstract void destroyThread(Thread var1);

    public void destroy() {
        int i;
        for (i = 0; i < this.idleThreads.size(); ++i) {
            this.destroyThread((Thread)this.busyThreads.get(i));
        }
        for (i = 0; i < this.busyThreads.size(); ++i) {
            this.destroyThread((Thread)this.busyThreads.get(i));
        }
        this.isDestroyed = true;
    }

    public synchronized int totalThreads() throws IllegalStateException {
        if (this.isDestroyed) {
            throw new IllegalStateException("This pool has been destroyed!");
        }
        return this.busyThreads.size() + this.idleThreads.size();
    }

    public synchronized int idleThreads() throws IllegalStateException {
        if (this.isDestroyed) {
            throw new IllegalStateException("This pool has been destroyed!");
        }
        return this.idleThreads.size();
    }

    public synchronized int busyThreads() throws IllegalStateException {
        if (this.isDestroyed) {
            throw new IllegalStateException("This pool has been destroyed!");
        }
        return this.busyThreads.size();
    }

    public synchronized void releaseThread(Thread thread) throws Exception {
        if (this.isDestroyed) {
            throw new IllegalStateException("This pool has been destroyed!");
        }
        this.busyThreads.remove(thread);
        this.idleThreads.add(thread);
    }

    public synchronized void lockThread(Thread thread) throws Exception {
        if (this.isDestroyed) {
            throw new IllegalStateException("This pool has been destroyed!");
        }
        this.busyThreads.add(thread);
        this.idleThreads.remove(thread);
    }

    public synchronized Thread getPooledThread() throws Exception {
        if (this.isDestroyed) {
            throw new IllegalStateException("This pool has been destroyed!");
        }
        if (this.idleThreads() > 0) {
            Thread thread = (Thread)this.idleThreads.get(0);
            this.lockThread(thread);
            return thread;
        }
        if (this.idleThreads() == 0 && this.busyThreads() < this.maxThreads) {
            Thread thread = this.createNewThread();
            this.busyThreads.add(thread);
            return thread;
        }
        try {
            Thread.yield();
            Thread.sleep(this.DELAY);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getPooledThread();
    }
}

