/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.rule.Action;
import org.dom4j.rule.Mode;
import org.dom4j.rule.Rule;
import org.dom4j.rule.RuleManager;

public class Stylesheet {
    private RuleManager ruleManager = new RuleManager();
    private String modeName;

    public void addRule(Rule rule) {
        this.ruleManager.addRule(rule);
    }

    public void removeRule(Rule rule) {
        this.ruleManager.addRule(rule);
    }

    public void run(Object input) throws Exception {
        this.run(input, this.modeName);
    }

    public void run(Object input, String mode) throws Exception {
        if (input instanceof Node) {
            this.run((Node)input, mode);
        } else if (input instanceof List) {
            this.run((List)input, mode);
        }
    }

    public void run(List list) throws Exception {
        this.run(list, this.modeName);
    }

    public void run(List list, String mode) throws Exception {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object object = list.get(i);
            if (!(object instanceof Node)) continue;
            this.run((Node)object, mode);
        }
    }

    public void run(Node node) throws Exception {
        this.run(node, this.modeName);
    }

    public void run(Node node, String mode) throws Exception {
        Mode mod = this.ruleManager.getMode(mode);
        mod.fireRule(node);
    }

    public void applyTemplates(Object input, XPath xpath) throws Exception {
        this.applyTemplates(input, xpath, this.modeName);
    }

    public void applyTemplates(Object input, XPath xpath, String mode) throws Exception {
        List list = xpath.selectNodes(input);
        list.remove(input);
        this.applyTemplates((Object)list, mode);
    }

    public void applyTemplates(Object input, org.jaxen.XPath xpath) throws Exception {
        this.applyTemplates(input, xpath, this.modeName);
    }

    public void applyTemplates(Object input, org.jaxen.XPath xpath, String mode) throws Exception {
        List list = xpath.selectNodes(input);
        this.applyTemplates((Object)list, mode);
    }

    public void applyTemplates(Object input) throws Exception {
        this.applyTemplates(input, this.modeName);
    }

    public void applyTemplates(Object input, String mode) throws Exception {
        Mode mod = this.ruleManager.getMode(mode);
        if (input instanceof Element) {
            mod.applyTemplates((Element)input);
        } else if (input instanceof Document) {
            mod.applyTemplates((Document)input);
        } else if (input instanceof List) {
            List list = (List)input;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object object = list.get(i);
                if (object == input) continue;
                if (object instanceof Element) {
                    mod.applyTemplates((Element)object);
                    continue;
                }
                if (!(object instanceof Document)) continue;
                mod.applyTemplates((Document)object);
            }
        }
    }

    public void clear() {
        this.ruleManager.clear();
    }

    public String getModeName() {
        return this.modeName;
    }

    public void setModeName(String modeName) {
        this.modeName = modeName;
    }

    public Action getValueOfAction() {
        return this.ruleManager.getValueOfAction();
    }

    public void setValueOfAction(Action valueOfAction) {
        this.ruleManager.setValueOfAction(valueOfAction);
    }
}

