/*
 * ConfigException.java,v 1.0 29/06/2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: ConfigException
 * Original Author: Thomas BELLEMBOIS
 */
package org.esupportail.portal.utils.injac.injacSpacesCreation.exception;

/**
 * @author : Thomas BELLEMBOIS
 * date : 29 juin 2004
 * Exception throwned by the Config class
 */

public class ConfigException extends Exception{
	
	String throwingClass;  // class throwing the exception
	String throwingMethod; // method throwing the exception
	String comment;        // comment
	
	public ConfigException(){
		this.comment = "";
		this.throwingClass = "";
		this.throwingMethod = "";		
	}// ConfigException
	
	public ConfigException(String throwingClass, String throwingMethod, String comment){
		this.comment = comment;
		this.throwingClass = throwingClass;
		this.throwingMethod = throwingMethod;		
	}// ConfigException
	
	public String toString(){
		String resultString;
		resultString = "ConfigException handled\n";
		resultString+= ">Class "+throwingClass+"\n";
		resultString+= ">Method "+throwingMethod+"\n";
		resultString+= ">>"+comment+"\n";
		return resultString; 
	}// toString
	
}// ConfigException
