/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresql.jdbc3.Jdbc3Connection;
import org.postgresql.util.PSQLException;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    public static boolean logDebug = false;
    public static boolean logInfo = false;
    private Properties props;
    private static String[] protocols;
    private static int m_buildNumber;

    public Connection connect(String url, Properties info) throws SQLException {
        this.props = this.parseURL(url, info);
        if (this.props == null) {
            if (logDebug) {
                Driver.debug("Error in url" + url);
            }
            return null;
        }
        try {
            if (logDebug) {
                Driver.debug("connect " + url);
            }
            Jdbc3Connection con = (Jdbc3Connection)Class.forName("org.postgresql.jdbc3.Jdbc3Connection").newInstance();
            con.openConnection(this.host(), this.port(), this.props, this.database(), url, this);
            return con;
        }
        catch (ClassNotFoundException ex) {
            if (logDebug) {
                Driver.debug("error", ex);
            }
            throw new PSQLException("postgresql.jvm.version", ex);
        }
        catch (PSQLException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            if (logDebug) {
                Driver.debug("error", ex2);
            }
            throw new PSQLException("postgresql.unusual", ex2);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties p = this.parseURL(url, info);
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 3;
    }

    public static String getVersion() {
        return "PostgreSQL 7.3.1 JDBC3 jdbc driver build " + m_buildNumber;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        int state = -1;
        Properties urlProps = new Properties(defaults);
        String key = "";
        String value = "";
        StringTokenizer st = new StringTokenizer(url, ":/;=&?", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count <= 3) {
                if (count % 2 != 1 || !token.equals(":")) {
                    if (count % 2 != 0) return null;
                    boolean found = count == 0;
                    int tmp = 0;
                    while (tmp < protocols.length) {
                        if (token.equals(protocols[tmp]) && count == 2 && tmp > 0) {
                            urlProps.put("Protocol", token);
                            found = true;
                        }
                        ++tmp;
                    }
                    if (!found) {
                        return null;
                    }
                }
            } else if (count > 3) {
                if (count == 4 && token.equals("/")) {
                    state = 0;
                } else if (count == 4) {
                    urlProps.put("PGDBNAME", token);
                    state = -2;
                } else if (count == 5 && state == 0 && token.equals("/")) {
                    state = 1;
                } else {
                    if (count == 5 && state == 0) {
                        return null;
                    }
                    if (count == 6 && state == 1) {
                        urlProps.put("PGHOST", token);
                    } else if (count == 7 && token.equals(":")) {
                        state = 2;
                    } else if (count == 8 && state == 2) {
                        try {
                            Integer portNumber = Integer.decode(token);
                            urlProps.put("PGPORT", portNumber.toString());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else if (!(count != 7 && count != 9 || state != 1 && state != 2 || !token.equals("/"))) {
                        state = -1;
                    } else if (state == -1) {
                        urlProps.put("PGDBNAME", token);
                        state = -2;
                    } else if (state <= -2 && count % 2 == 1) {
                        if (token.equals(";") || token.equals("?") || token.equals("&")) {
                            state = -3;
                        } else if (token.equals("=")) {
                            state = -5;
                        }
                    } else if (state <= -2 && count % 2 == 0) {
                        if (state == -3) {
                            key = token;
                        } else if (state == -5) {
                            value = token;
                            urlProps.put(key, value);
                            state = -2;
                        }
                    }
                }
            }
            ++count;
        }
        return urlProps;
    }

    public String host() {
        return this.props.getProperty("PGHOST", "localhost");
    }

    public int port() {
        return Integer.parseInt(this.props.getProperty("PGPORT", "5432"));
    }

    public String database() {
        return this.props.getProperty("PGDBNAME", "");
    }

    public String property(String name) {
        return this.props.getProperty(name);
    }

    public static SQLException notImplemented() {
        return new PSQLException("postgresql.unimplemented");
    }

    public static void setLogLevel(int logLevel) {
        logDebug = logLevel >= 2;
        logInfo = logLevel >= 1;
    }

    public static void debug(String msg) {
        if (logDebug) {
            DriverManager.println(msg);
        }
    }

    public static void debug(String msg, Exception ex) {
        if (logDebug) {
            DriverManager.println(msg + ex != null ? ex.getMessage() : "null Exception");
        }
    }

    public static void info(String msg) {
        if (logInfo) {
            DriverManager.println(msg);
        }
    }

    public static void info(String msg, Exception ex) {
        if (logInfo) {
            DriverManager.println(msg + ex != null ? ex.getMessage() : "null Exception");
        }
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        protocols = new String[]{"jdbc", "postgresql"};
        m_buildNumber = 107;
    }
}

