/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;
import org.postgresql.PG_Stream;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.StartupPacket;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.jdbc1.AbstractJdbc1ResultSet;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.Serialize;
import org.postgresql.util.UnixCrypt;

public abstract class AbstractJdbc1Connection
implements PGConnection {
    public PG_Stream pg_stream;
    protected String PG_HOST;
    protected int PG_PORT;
    protected String PG_USER;
    protected String PG_DATABASE;
    protected boolean PG_STATUS;
    protected String compatible;
    protected int pid;
    protected int ckey;
    private Vector m_notifications;
    private Encoding encoding = Encoding.defaultEncoding();
    private String dbVersionNumber;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    protected static final int PG_PROTOCOL_LATEST_MAJOR = 2;
    protected static final int PG_PROTOCOL_LATEST_MINOR = 0;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static Hashtable sqlTypeCache = new Hashtable();
    private static Hashtable pgTypeCache = new Hashtable();
    private static Hashtable typeOidCache = new Hashtable();
    public SQLWarning firstWarning = null;
    private int isolationLevel = 2;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    int lastMessage = 0;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "org.postgresql.geometric.PGbox"}, {"circle", "org.postgresql.geometric.PGcircle"}, {"line", "org.postgresql.geometric.PGline"}, {"lseg", "org.postgresql.geometric.PGlseg"}, {"path", "org.postgresql.geometric.PGpath"}, {"point", "org.postgresql.geometric.PGpoint"}, {"polygon", "org.postgresql.geometric.PGpolygon"}, {"money", "org.postgresql.util.PGmoney"}};
    protected DatabaseMetaData metadata;
    private static final String[] jdbc1Types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "date", "time", "abstime", "timestamp", "timestamptz"};
    private static final int[] jdbc1Typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, 91, 92, 93, 93, 93};

    public abstract Statement createStatement() throws SQLException;

    public void openConnection(String host, int port, Properties info, String database, String url, Driver d) throws SQLException {
        int beresp;
        this.firstWarning = null;
        if (info.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user");
        }
        this.this_driver = d;
        this.this_url = url;
        this.PG_DATABASE = database;
        this.PG_USER = info.getProperty("user");
        String password = info.getProperty("password", "");
        this.PG_PORT = port;
        this.PG_HOST = host;
        this.PG_STATUS = this.CONNECTION_BAD;
        this.compatible = info.getProperty("compatible") == null ? d.getMajorVersion() + "." + d.getMinorVersion() : info.getProperty("compatible");
        String l_logLevelProp = info.getProperty("loglevel", "0");
        int l_logLevel = 0;
        try {
            l_logLevel = Integer.parseInt(l_logLevelProp);
            if (l_logLevel > 2 || l_logLevel < 1) {
                l_logLevel = 0;
            }
        }
        catch (Exception l_e) {
            // empty catch block
        }
        if (l_logLevel > 0) {
            Driver.setLogLevel(l_logLevel);
            this.enableDriverManagerLogging();
        }
        if (Driver.logInfo) {
            Driver.info(Driver.getVersion());
        }
        try {
            this.pg_stream = new PG_Stream(host, port);
        }
        catch (ConnectException cex) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.con.failed", e);
        }
        try {
            new StartupPacket(2, 0, this.PG_USER, database).writeTo(this.pg_stream);
            this.pg_stream.flush();
            int areq = -1;
            do {
                int beresp2 = this.pg_stream.ReceiveChar();
                String salt = null;
                byte[] md5Salt = new byte[4];
                block3 : switch (beresp2) {
                    case 69: {
                        throw new PSQLException("postgresql.con.misc", (Object)this.pg_stream.ReceiveString(this.encoding));
                    }
                    case 82: {
                        areq = this.pg_stream.ReceiveIntegerR(4);
                        if (areq == 4) {
                            byte[] rst = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            salt = new String(rst, 0, 2);
                            if (Driver.logDebug) {
                                Driver.debug("Crypt salt=" + salt);
                            }
                        }
                        if (areq == 5) {
                            md5Salt[0] = (byte)this.pg_stream.ReceiveChar();
                            md5Salt[1] = (byte)this.pg_stream.ReceiveChar();
                            md5Salt[2] = (byte)this.pg_stream.ReceiveChar();
                            md5Salt[3] = (byte)this.pg_stream.ReceiveChar();
                            salt = new String(md5Salt, 0, 4);
                            if (Driver.logDebug) {
                                Driver.debug("MD5 salt=" + salt);
                            }
                        }
                        switch (areq) {
                            case 0: {
                                break block3;
                            }
                            case 1: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: KRB4");
                                }
                                throw new PSQLException("postgresql.con.kerb4");
                            }
                            case 2: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: KRB5");
                                }
                                throw new PSQLException("postgresql.con.kerb5");
                            }
                            case 3: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: PASSWORD");
                                }
                                this.pg_stream.SendInteger(5 + password.length(), 4);
                                this.pg_stream.Send(password.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                break block3;
                            }
                            case 4: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: CRYPT");
                                }
                                String crypted = UnixCrypt.crypt(salt, password);
                                this.pg_stream.SendInteger(5 + crypted.length(), 4);
                                this.pg_stream.Send(crypted.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                break block3;
                            }
                            case 5: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: MD5");
                                }
                                byte[] digest = MD5Digest.encode(this.PG_USER, password, md5Salt);
                                this.pg_stream.SendInteger(5 + digest.length, 4);
                                this.pg_stream.Send(digest);
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                break block3;
                            }
                        }
                        throw new PSQLException("postgresql.con.auth", new Integer(areq));
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail");
                    }
                }
            } while (areq != 0);
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.con.failed", e);
        }
        do {
            beresp = this.pg_stream.ReceiveChar();
            switch (beresp) {
                case 75: {
                    this.pid = this.pg_stream.ReceiveIntegerR(4);
                    this.ckey = this.pg_stream.ReceiveIntegerR(4);
                    break;
                }
                case 69: {
                    throw new PSQLException("postgresql.con.backend", (Object)this.pg_stream.ReceiveString(this.encoding));
                }
                case 78: {
                    this.addWarning(this.pg_stream.ReceiveString(this.encoding));
                    break;
                }
                default: {
                    throw new PSQLException("postgresql.con.setup");
                }
            }
        } while (beresp == 78);
        do {
            beresp = this.pg_stream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    break;
                }
                case 78: {
                    this.addWarning(this.pg_stream.ReceiveString(this.encoding));
                    break;
                }
                case 69: {
                    throw new PSQLException("postgresql.con.backend", (Object)this.pg_stream.ReceiveString(this.encoding));
                }
                default: {
                    throw new PSQLException("postgresql.con.setup");
                }
            }
        } while (beresp == 78);
        String encodingQuery = "case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end";
        ResultSet resultSet = this.ExecSQL("set datestyle to 'ISO'; select version(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end;");
        if (!resultSet.next()) {
            throw new PSQLException("postgresql.con.failed", (Object)"failed getting backend encoding");
        }
        String version = resultSet.getString(1);
        this.dbVersionNumber = AbstractJdbc1Connection.extractVersionNumber(version);
        String dbEncoding = resultSet.getString(2);
        this.encoding = Encoding.getEncoding(dbEncoding, info.getProperty("charSet"));
        if (this.haveMinimumServerVersion("7.3")) {
            ResultSet acRset = this.ExecSQL("set client_encoding = 'UNICODE'; show autocommit");
            this.encoding = Encoding.getEncoding("UNICODE", null);
            if (!acRset.next()) {
                throw new PSQLException("postgresql.con.failed", (Object)"failed getting autocommit status");
            }
            if (acRset.getString(1).equals("off")) {
                this.ExecSQL("set autocommit = on; commit;");
            }
        }
        this.initObjectTypes();
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public Driver getDriver() {
        return this.this_driver;
    }

    public abstract ResultSet getResultSet(Statement var1, Field[] var2, Vector var3, String var4, int var5, long var6, boolean var8) throws SQLException;

    public abstract ResultSet getResultSet(Statement var1, Field[] var2, Vector var3, String var4, int var5) throws SQLException;

    public void addWarning(String msg) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(msg));
        } else {
            this.firstWarning = new SQLWarning(msg);
        }
    }

    public ResultSet ExecSQL(String sql) throws SQLException {
        return this.ExecSQL(sql, null);
    }

    public ResultSet ExecSQL(String sql, Statement stat) throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException("postgresql.con.closed");
        }
        return new QueryExecutor(new String[]{sql}, EMPTY_OBJECT_ARRAY, stat, this.pg_stream, (Connection)((Object)this)).execute();
    }

    public ResultSet ExecSQL(String[] p_sqlFragments, Object[] p_binds, Statement stat) throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException("postgresql.con.closed");
        }
        return new QueryExecutor(p_sqlFragments, p_binds, stat, this.pg_stream, (Connection)((Object)this)).execute();
    }

    public void setCursorName(String cursor) throws SQLException {
        this.cursor = cursor;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    public Encoding getEncoding() throws SQLException {
        return this.encoding;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pg_stream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager((Connection)((Object)this));
        }
        return this.largeobject;
    }

    public Object getObject(String type, String value) throws SQLException {
        try {
            Object o = this.objectTypes.get(type);
            if (o == null) {
                Serialize ser = new Serialize((Connection)((Object)this), type);
                this.objectTypes.put(type, ser);
                return ser.fetch(Integer.parseInt(value));
            }
            if (o instanceof String) {
                PGobject obj = null;
                obj = (PGobject)Class.forName((String)o).newInstance();
                obj.setType(type);
                obj.setValue(value);
                return obj;
            }
            if (o instanceof Serialize) {
                return ((Serialize)o).fetch(Integer.parseInt(value));
            }
        }
        catch (SQLException sx) {
            sx.fillInStackTrace();
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException("postgresql.con.creobj", (Object)type, (Object)ex);
        }
        return null;
    }

    public int putObject(Object o) throws SQLException {
        return (int)this.storeObject(o);
    }

    public long storeObject(Object o) throws SQLException {
        try {
            String type = o.getClass().getName();
            Object x = this.objectTypes.get(type);
            if (x == null) {
                Serialize ser = new Serialize((Connection)((Object)this), type);
                this.objectTypes.put(type, ser);
                return ser.storeObject(o);
            }
            if (x instanceof Serialize) {
                return ((Serialize)x).storeObject(o);
            }
            throw new PSQLException("postgresql.con.strobj");
        }
        catch (SQLException sx) {
            sx.fillInStackTrace();
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException("postgresql.con.strobjex", ex);
        }
    }

    public void addDataType(String type, String name) {
        this.objectTypes.put(type, name);
    }

    private void initObjectTypes() {
        int i = 0;
        while (i < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[i][0], defaultObjectTypes[i][1]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.pg_stream != null) {
            try {
                try {
                    this.pg_stream.SendChar(88);
                    this.pg_stream.flush();
                    this.pg_stream.close();
                }
                catch (IOException e) {
                    Object var3_2 = null;
                    this.pg_stream = null;
                }
                Object var3_1 = null;
                this.pg_stream = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.pg_stream = null;
                throw throwable;
            }
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (autoCommit) {
            if (this.haveMinimumServerVersion("7.3")) {
                this.ExecSQL("select 1; commit; set autocommit = on;");
            } else {
                this.ExecSQL("end");
            }
        } else if (this.haveMinimumServerVersion("7.3")) {
            this.ExecSQL("set autocommit = off; " + this.getIsolationLevelSQL());
        } else if (this.haveMinimumServerVersion("7.1")) {
            this.ExecSQL("begin;" + this.getIsolationLevelSQL());
        } else {
            this.ExecSQL("begin");
            this.ExecSQL(this.getIsolationLevelSQL());
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.3")) {
            this.ExecSQL("commit; " + this.getIsolationLevelSQL());
        } else if (this.haveMinimumServerVersion("7.1")) {
            this.ExecSQL("commit;begin;" + this.getIsolationLevelSQL());
        } else {
            this.ExecSQL("commit");
            this.ExecSQL("begin");
            this.ExecSQL(this.getIsolationLevelSQL());
        }
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.3")) {
            this.ExecSQL("rollback; " + this.getIsolationLevelSQL());
        } else if (this.haveMinimumServerVersion("7.1")) {
            this.ExecSQL("rollback; begin;" + this.getIsolationLevelSQL());
        } else {
            this.ExecSQL("rollback");
            this.ExecSQL("begin");
            this.ExecSQL(this.getIsolationLevelSQL());
        }
    }

    public int getTransactionIsolation() throws SQLException {
        String sql = "show transaction isolation level";
        String level = null;
        if (this.haveMinimumServerVersion("7.3")) {
            ResultSet rs = this.ExecSQL(sql);
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            this.clearWarnings();
            this.ExecSQL(sql);
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
        }
        if (level != null) {
            if (level.indexOf("READ COMMITTED") != -1) {
                return 2;
            }
            if (level.indexOf("READ UNCOMMITTED") != -1) {
                return 1;
            }
            if (level.indexOf("REPEATABLE READ") != -1) {
                return 4;
            }
            if (level.indexOf("SERIALIZABLE") != -1) {
                return 8;
            }
        }
        return 2;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String isolationLevelSQL;
        this.isolationLevel = level;
        if (!this.haveMinimumServerVersion("7.1")) {
            isolationLevelSQL = this.getIsolationLevelSQL();
        } else {
            isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
            switch (this.isolationLevel) {
                case 2: {
                    isolationLevelSQL = isolationLevelSQL + "READ COMMITTED";
                    break;
                }
                case 8: {
                    isolationLevelSQL = isolationLevelSQL + "SERIALIZABLE";
                    break;
                }
                default: {
                    throw new PSQLException("postgresql.con.isolevel", new Integer(this.isolationLevel));
                }
            }
        }
        this.ExecSQL(isolationLevelSQL);
    }

    protected String getIsolationLevelSQL() throws SQLException {
        if (this.haveMinimumServerVersion("7.1")) {
            return "";
        }
        StringBuffer sb = new StringBuffer("SET TRANSACTION ISOLATION LEVEL");
        switch (this.isolationLevel) {
            case 2: {
                sb.append(" READ COMMITTED");
                break;
            }
            case 8: {
                sb.append(" SERIALIZABLE");
                break;
            }
            default: {
                throw new PSQLException("postgresql.con.isolevel", new Integer(this.isolationLevel));
            }
        }
        return sb.toString();
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.PG_DATABASE;
    }

    public void finalize() throws Throwable {
        this.close();
    }

    private static String extractVersionNumber(String fullVersionString) {
        StringTokenizer versionParts = new StringTokenizer(fullVersionString);
        versionParts.nextToken();
        return versionParts.nextToken();
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    public boolean haveMinimumServerVersion(String ver) throws SQLException {
        return this.getDBVersionNumber().compareTo(ver) >= 0;
    }

    public boolean haveMinimumCompatibleVersion(String ver) throws SQLException {
        return this.compatible.compareTo(ver) >= 0;
    }

    public int getSQLType(int oid) throws SQLException {
        Integer sqlType = (Integer)sqlTypeCache.get(new Integer(oid));
        if (sqlType == null) {
            String pgType;
            if (oid == 0) {
                pgType = "opaque";
            } else {
                String sql = this.haveMinimumServerVersion("7.3") ? "SELECT typname FROM pg_catalog.pg_type WHERE oid = " + oid : "SELECT typname FROM pg_type WHERE oid = " + oid;
                ResultSet result = this.ExecSQL(sql);
                if (((AbstractJdbc1ResultSet)((Object)result)).getColumnCount() != 1 || ((AbstractJdbc1ResultSet)((Object)result)).getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected");
                }
                result.next();
                pgType = result.getString(1);
                result.close();
            }
            Integer iOid = new Integer(oid);
            sqlType = new Integer(this.getSQLType(pgType));
            sqlTypeCache.put(iOid, sqlType);
            pgTypeCache.put(iOid, pgType);
        }
        return sqlType;
    }

    public int getPGType(String typeName) throws SQLException {
        int oid = -1;
        if (typeName != null) {
            Integer oidValue = (Integer)typeOidCache.get(typeName);
            if (oidValue != null) {
                oid = oidValue;
            } else {
                String sql = this.haveMinimumServerVersion("7.3") ? "SELECT oid FROM pg_catalog.pg_type WHERE typname='" + typeName + "'" : "SELECT oid FROM pg_type WHERE typname='" + typeName + "'";
                ResultSet result = this.ExecSQL(sql);
                if (((AbstractJdbc1ResultSet)((Object)result)).getColumnCount() != 1 || ((AbstractJdbc1ResultSet)((Object)result)).getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected");
                }
                result.next();
                oid = Integer.parseInt(result.getString(1));
                typeOidCache.put(typeName, new Integer(oid));
                result.close();
            }
        }
        return oid;
    }

    public String getPGType(int oid) throws SQLException {
        String pgType = (String)pgTypeCache.get(new Integer(oid));
        if (pgType == null) {
            this.getSQLType(oid);
            pgType = (String)pgTypeCache.get(new Integer(oid));
        }
        return pgType;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogStream() == null) {
            DriverManager.setLogStream(System.out);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.pg_stream == null;
    }

    public int getSQLType(String pgTypeName) {
        int sqlType = 1111;
        int i = 0;
        while (i < jdbc1Types.length) {
            if (pgTypeName.equals(jdbc1Types[i])) {
                sqlType = jdbc1Typei[i];
                break;
            }
            ++i;
        }
        return sqlType;
    }

    public void addNotification(PGNotification p_notification) {
        if (this.m_notifications == null) {
            this.m_notifications = new Vector();
        }
        this.m_notifications.addElement(p_notification);
    }

    public PGNotification[] getNotifications() {
        Object[] l_return = null;
        if (this.m_notifications != null) {
            l_return = new PGNotification[this.m_notifications.size()];
            this.m_notifications.copyInto(l_return);
        }
        this.m_notifications = null;
        return l_return;
    }
}

