/*
 * Decompiled with CFR 0.152.
 */
package com.jenkov.tags.tree.impl;

import com.jenkov.tags.tree.impl.TreeIterator;
import com.jenkov.tags.tree.itf.ICollapseListener;
import com.jenkov.tags.tree.itf.IExpandListener;
import com.jenkov.tags.tree.itf.ISelectListener;
import com.jenkov.tags.tree.itf.ITree;
import com.jenkov.tags.tree.itf.ITreeNode;
import com.jenkov.tags.tree.itf.IUnselectListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Tree
implements ITree {
    protected boolean singleSelectionMode = false;
    protected Set expanded = new TreeSet();
    protected Set selected = new TreeSet();
    protected ITreeNode root = null;
    protected List expandListeners = new ArrayList();
    protected List collapseListeners = new ArrayList();
    protected List selectListeners = new ArrayList();
    protected List unselectListeners = new ArrayList();

    public ITreeNode getRoot() {
        return this.root;
    }

    public void setRoot(ITreeNode node) {
        this.root = node;
    }

    public ITreeNode findNode(String treeNodeId) {
        return this.findNode(this.getRoot(), treeNodeId);
    }

    protected ITreeNode findNode(ITreeNode treeNode, String treeNodeId) {
        if (treeNode.getId().equals(treeNodeId)) {
            return treeNode;
        }
        Iterator children = treeNode.getChildren().iterator();
        while (children.hasNext()) {
            ITreeNode child = (ITreeNode)children.next();
            ITreeNode match = this.findNode(child, treeNodeId);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public Set findNodes(Set treeNodeIds) {
        HashSet treeNodes = new HashSet();
        this.findNodes(this.getRoot(), treeNodeIds, treeNodes);
        return treeNodes;
    }

    protected void findNodes(ITreeNode treeNode, Set treeNodeIds, Set treeNodes) {
        if (treeNodeIds.contains(treeNode.getId())) {
            treeNodes.add(treeNode);
        }
        Iterator children = treeNode.getChildren().iterator();
        while (children.hasNext()) {
            this.findNodes((ITreeNode)children.next(), treeNodeIds, treeNodes);
        }
    }

    public boolean isExpanded(String treeNodeId) {
        return this.expanded.contains(treeNodeId);
    }

    public void expand(String treeNodeId) {
        this.expanded.add(treeNodeId);
        if (this.expandListeners.size() > 0) {
            ITreeNode expandedNode = this.findNode(treeNodeId);
            Iterator iterator = this.expandListeners.iterator();
            while (iterator.hasNext()) {
                ((IExpandListener)iterator.next()).nodeExpanded(expandedNode, this);
            }
        }
    }

    public void collapse(String treeNodeId) {
        this.expanded.remove(treeNodeId);
        if (this.collapseListeners.size() > 0) {
            ITreeNode collapsedNode = this.findNode(treeNodeId);
            Iterator iterator = this.collapseListeners.iterator();
            while (iterator.hasNext()) {
                ((ICollapseListener)iterator.next()).nodeCollapsed(collapsedNode, this);
            }
        }
    }

    public Set getExpandedNodes() {
        return this.findNodes(this.expanded);
    }

    public void addExpandListener(IExpandListener expandListener) {
        this.expandListeners.add(expandListener);
    }

    public void removeExpandListener(IExpandListener expandListener) {
        this.expandListeners.remove(expandListener);
    }

    public void addCollapseListener(ICollapseListener collapseListener) {
        this.collapseListeners.add(collapseListener);
    }

    public void removeCollapseListener(ICollapseListener collapseListener) {
        this.collapseListeners.remove(collapseListener);
    }

    public boolean isSelected(String treeNodeId) {
        return this.selected.contains(treeNodeId);
    }

    public void select(String treeNodeId) {
        if (this.isSingleSelectionMode()) {
            this.unSelectAll();
        }
        this.selected.add(treeNodeId);
        if (this.selectListeners.size() > 0) {
            ITreeNode selectedNode = this.findNode(treeNodeId);
            Iterator iterator = this.selectListeners.iterator();
            while (iterator.hasNext()) {
                ((ISelectListener)iterator.next()).nodeSelected(selectedNode, this);
            }
        }
    }

    public void unSelect(String treeNodeId) {
        this.selected.remove(treeNodeId);
        if (this.unselectListeners.size() > 0) {
            ITreeNode unselectedNode = this.findNode(treeNodeId);
            Iterator iterator = this.unselectListeners.iterator();
            while (iterator.hasNext()) {
                ((IUnselectListener)iterator.next()).nodeUnselected(unselectedNode, this);
            }
        }
    }

    public void unSelectAll() {
        Iterator iterator = this.selected.iterator();
        while (iterator.hasNext()) {
            this.unSelect((String)iterator.next());
        }
    }

    public Set getSelectedNodes() {
        return this.findNodes(this.selected);
    }

    public void setSingleSelectionMode(boolean mode) {
        this.singleSelectionMode = mode;
    }

    public boolean isSingleSelectionMode() {
        return this.singleSelectionMode;
    }

    public void addSelectListener(ISelectListener selectListener) {
        this.selectListeners.add(selectListener);
    }

    public void removeSelectListener(ISelectListener selectListener) {
        this.selectListeners.remove(selectListener);
    }

    public void addUnselectListener(IUnselectListener unselectListener) {
        this.unselectListeners.add(unselectListener);
    }

    public void removeUnselectListener(IUnselectListener unselectListener) {
        this.unselectListeners.remove(unselectListener);
    }

    public Iterator iterator(boolean includeRootNode) {
        return new TreeIterator(this, includeRootNode);
    }
}

