/*
 * Decompiled with CFR 0.152.
 */
package com.jenkov.tags.tree.impl;

import com.jenkov.tags.tree.impl.TreeIteratorElement;
import com.jenkov.tags.tree.itf.ITree;
import com.jenkov.tags.tree.itf.ITreeIteratorElement;
import com.jenkov.tags.tree.itf.ITreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeIterator
implements Iterator {
    protected ITree tree = null;
    protected TreeNodeStack stack = new TreeNodeStack();
    protected int level = 0;

    public TreeIterator(ITree tree, boolean includeRootNode) {
        this.tree = tree;
        this.stack.push(new TreeIteratorElement(tree.getRoot(), new ArrayList(), tree.isExpanded(tree.getRoot().getId()), tree.isSelected(tree.getRoot().getId()), true, true));
        if (!includeRootNode) {
            this.pushChildren((ITreeIteratorElement)this.stack.pop());
        }
    }

    public boolean hasNext() {
        return this.stack.size() > 0;
    }

    public Object next() {
        ITreeIteratorElement element = (ITreeIteratorElement)this.stack.pop();
        if (this.tree.isExpanded(element.getNode().getId())) {
            this.pushChildren(element);
        }
        return element;
    }

    public void remove() {
    }

    protected void pushChildren(ITreeIteratorElement element) {
        List indentationProfile = this.copyIndentationProfile(element);
        indentationProfile.add(new Boolean(element.isLastChild()));
        List children = element.getNode().getChildren();
        int i = 0;
        while (i < children.size()) {
            ITreeNode node = (ITreeNode)children.get(children.size() - i - 1);
            this.stack.push(new TreeIteratorElement(node, indentationProfile, this.tree.isExpanded(node.getId()), this.tree.isSelected(node.getId()), i == children.size() - 1, i == 0));
            ++i;
        }
    }

    protected List copyIndentationProfile(ITreeIteratorElement element) {
        ArrayList copy = new ArrayList();
        Iterator iterator = element.getIndendationProfile().iterator();
        while (iterator.hasNext()) {
            copy.add(iterator.next());
        }
        return copy;
    }

    private class TreeNodeStack {
        protected List stackContents = new ArrayList();

        private TreeNodeStack() {
        }

        public int size() {
            return this.stackContents.size();
        }

        public void push(Object node) {
            this.stackContents.add(node);
        }

        public Object pop() {
            Object node = this.stackContents.get(this.stackContents.size() - 1);
            this.stackContents.remove(this.stackContents.size() - 1);
            return node;
        }

        public Object top() {
            return this.stackContents.get(this.stackContents.size() - 1);
        }
    }
}

