/*
 * Decompiled with CFR 0.152.
 */
package com.jenkov.tags.tree.impl;

import com.jenkov.tags.tree.itf.ITree;
import com.jenkov.tags.tree.itf.ITreeIteratorElement;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class TreeTag
extends TagSupport {
    protected String tree = null;
    protected String node = null;
    protected String level = null;
    protected String expanded = null;
    protected Iterator treeIterator = null;
    protected String expandParam = null;
    protected String collapseParam = null;
    protected String includeRootNode = null;

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getExpandParam() {
        if (this.expandParam == null) {
            return "expand";
        }
        return this.expandParam;
    }

    public void setExpandParam(String expandParam) {
        this.expandParam = expandParam;
    }

    public String getCollapseParam() {
        if (this.collapseParam == null) {
            return "collapse";
        }
        return this.collapseParam;
    }

    public void setCollapseParam(String collapseParam) {
        this.collapseParam = collapseParam;
    }

    public String getIncludeRootNode() {
        if (this.includeRootNode == null) {
            return "true";
        }
        return this.includeRootNode;
    }

    public void setIncludeRootNode(String includeRootNode) {
        this.includeRootNode = includeRootNode;
    }

    protected void validateAttributes() throws JspException {
        if (this.getTree() == null) {
            throw new JspException("attribute tree must not be null!");
        }
        if (this.getNode() == null) {
            throw new JspException("attribute node must not be null!");
        }
    }

    protected boolean isTreeAvailable() throws JspException {
        return this.pageContext.getSession().getAttribute(this.getTree()) != null;
    }

    protected void expandCollapseNode() {
        String expandId = this.pageContext.getRequest().getParameter(this.getExpandParam());
        String collapseId = this.pageContext.getRequest().getParameter(this.getCollapseParam());
        ITree tree = (ITree)this.pageContext.getSession().getAttribute(this.getTree());
        if (expandId != null) {
            tree.expand(expandId);
        } else if (collapseId != null) {
            tree.collapse(collapseId);
        }
    }

    public int doStartTag() throws JspException {
        this.validateAttributes();
        this.expandCollapseNode();
        if (!this.isTreeAvailable()) {
            return 0;
        }
        ITree tree = (ITree)this.pageContext.getSession().getAttribute(this.getTree());
        this.treeIterator = tree.iterator(this.getIncludeRootNode().equals("true"));
        if (this.treeIterator.hasNext()) {
            ITreeIteratorElement element = (ITreeIteratorElement)this.treeIterator.next();
            this.pageContext.getSession().setAttribute(this.getNode(), (Object)element);
            return 1;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        if (this.treeIterator.hasNext()) {
            ITreeIteratorElement element = (ITreeIteratorElement)this.treeIterator.next();
            this.pageContext.getSession().setAttribute(this.getNode(), (Object)element);
            return 2;
        }
        return 0;
    }
}

