/*
 *  Copyright 2002 Jason Klassen, Sean Gustafson, Simon Gould
 *  		Almer Avecilla, Sebastien Robin, Olivier Jaton
 *
 *  This file is part of Student Exam Prep.
 *
 *  Student Exam Prep is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Student Exam Prep is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Student Exam Prep; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.sql.*;
import javax.servlet.ServletException;

import fr.univvalenciennes.publi.utils.properties.*;


public class Database {

  
  
	private String driver;
	private String userId;
	private String password;
	private String url;

	public Database() {
	}

	public Database(String driver , String userId , String password , String url) {
		this.driver = driver;
		this.userId = userId;
		this.password = password;
		this.url = url;

	}

	public Connection getConnection () {
		try{
			Class.forName(driver);
			return DriverManager.getConnection(url,userId,password);
		}
		catch(SQLException sqle){
			System.out.println("SQLException "+sqle);
		}
		catch(ClassNotFoundException cnfe){
		 System.out.println("ClassNotFoundException (Postgresql) "+cnfe);
		}
		return null;
	}

	public static Database getStandard() {
		
		new PropertiesManager("applinews.properties");
		String DRIVER = PropertiesManager.getProperty("jdbcDriver");
		String USERID = PropertiesManager.getProperty("jdbcUser");
		String PASSWORD = PropertiesManager.getProperty("jdbcPassword");
		String URL = PropertiesManager.getProperty("jdbcUrl");
		
		return new Database(DRIVER , USERID , PASSWORD , URL);

	}
  
}
