

import java.io.*;
import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;

import fr.univvalenciennes.publi.utils.properties.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * Description :<br/>
 * Cette classe permet d'authentifier l'utilisateur qui demande 
 *  se connecter au service de publication de messages
 * @version $Id : LdapHandler.java, V1.0, 20 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : LdapHandler<br/>
 * @author  ???<br/>Doriane Dusart<br/>
 * 
 *
 */

public class LdapHandler {
	private static Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	/**
	 * Paramtres de connexion  la base
	 */
    private  String url; 
    private  String baseDN;
    private  String uidAttribute; 
 

	/**
	 * Constructeur permettant de rcuprer les 
	 * paramtres de connexion  la base LDAP :
	 * url, baseDN, uidAttribute
	 */
	public LdapHandler(){
		new PropertiesManager("applinews.properties");
		url = PropertiesManager.getProperty("ldapUrl");
		baseDN =  PropertiesManager.getProperty("ldapBaseDN");
		uidAttribute =  PropertiesManager.getProperty("ldapUidAttribute");
	}

	/**
	 *	Cette methode permet d'authentifier la personne 
	 * @param username
	 * @param password
	 * @return
	 */
    public boolean authenticate(String username, String password){
      StringBuffer dnBuffer = new StringBuffer("uid=");
      dnBuffer.append(username).append(",").append(baseDN);
      DirContext conn = null;
      boolean status;
      //PrintStream log = null;

 
	  log.debug("Provider URL is " + url);
	  log.debug("DN is: " + dnBuffer.toString());
	  log.debug("Trying to auth " + username);
      try {
	Hashtable env = new Hashtable(5, 0.75f);
	env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
	env.put(Context.PROVIDER_URL, url);
	env.put(Context.SECURITY_AUTHENTICATION, "simple");
	env.put(Context.SECURITY_PRINCIPAL, dnBuffer.toString());
	env.put(Context.SECURITY_CREDENTIALS, password);;
	conn = new InitialDirContext(env);
	log.info("Authentification reussie pour : " + username);
	status = true;
      } catch (Exception e) {
	status = false;
	log.error(e.toString());
      } finally {
	if ( conn != null )
	  try {
            conn.close();
	  } catch (Exception e) {
		log.error("Erreur : "+e);
	  }
      }

      return status;
    }
}
