
import java.util.*;
import java.io.IOException;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.sql.*;

/**
 *  Module d'authentification via une base LDAP
 * 
 * Si un utilisateur est authentifi, un objet SimplePrincipal
 * avec le nom d'utilisateur est ajout au subjet
 * Description :<br/>
 * @version $Id : SimpleLoginModuleLDAP.java, V1.0, 20 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SimpleLoginModuleLDAP<br/>
 * @author  ???<br/>
 * Doriane Dusart<br/>
 * 
 *
 */
public class SimpleLoginModuleCAS implements LoginModule {
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
  /**
   * Etat initial
   */
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;

/** 
 * <p> This LoginModule recognizes the debug option.
 * If set to true in the login Configuration, debug messages 
 * will be output to the output stream, System.out.
 */
    private boolean debug = false;

    /**
     * Le status d'authentification
     */ 
    private boolean succeeded = false;
    private boolean commitSucceeded = false;

	/**
	 * Utilisateur courant
	 */
	private String username;
	//private String password;
	
	/**
	 * Objet principal attache a l'utilisateur
	 */
     private SimplePrincipal userPrincipal;

	/**
	* Initializes the <code>LoginModule</code>.
	*
	* <p>
	*
	* @param subject the <code>Subject</code> to be authenticated. <p>
	*
	* @param callbackHandler a <code>CallbackHandler</code> for communicating
	*			with the end user (prompting for user names and
	*			passwords, for example). <p>
	*
	* @param sharedState shared <code>LoginModule</code> state. <p>
	*
	* @param options options specified in the login
	*			<code>Configuration</code> for this particular
	*			<code>LoginModule</code>.
	*/
    public void initialize(Subject subject, CallbackHandler callbackHandler,
			Map sharedState, Map options) {
 
		this.subject = subject;
		this.callbackHandler = callbackHandler;
		this.sharedState = sharedState;
		this.options = options;
	
		// initialize any configured options
		debug = "true".equalsIgnoreCase((String)options.get("debug"));
			
		SimplePrincipal.setDebug( debug );
    }

    /**
     * Authenticate the user by prompting for a user name and password. 
     * The supplied user name and password are then compared to the list
     * of names and passwords (mapped by array index).
     *
     * <p>
     *
     * @return true in all cases since this <code>LoginModule</code>
     *		should not be ignored.
     *
     * @exception FailedLoginException if the authentication fails. <p>
     *
     * @exception LoginException if this <code>LoginModule</code>
     *		is unable to perform the authentication.
     */
    public boolean login() throws LoginException {

		// prompt for a user name and password
		if( callbackHandler == null )
		    throw new LoginException( "Error: no CallbackHandler available " +
				"to garner authentication information from the user" );
	
		Callback[] callbacks = new Callback[1];
		callbacks[0] = new NameCallback( "\nuser name: " );
		//callbacks[1] = new PasswordCallback( "password: ", false );
	 
		try {
		    callbackHandler.handle(callbacks);
		    username = ((NameCallback)callbacks[0]).getName();
		    log.info("username = "+username);
			//password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
			//if(password == null){
			//	password ="";
			//}
			//((PasswordCallback)callbacks[1]).clearPassword();
		} catch( java.io.IOException ioe ) {
		    throw new LoginException(ioe.toString());
		} catch( UnsupportedCallbackException uce ) {
		    throw new LoginException( "Error: " + uce.getCallback().toString() +
				" not available to authenticate user." );
		}
	

		    log.info( "\t[SimpleLoginModuleCAS] " +"nom d'utilisateur entre: " + username );	  
		
  
 succeeded =true;
  
	if(succeeded){				//DD
  	  log.debug("\t\t[SimpleLoginModuleCAS] " + "authentication succeeded");
      succeeded = true;
    } else {
	  log.debug("\t\t[SimpleLoginModuleCAS] " + "authentication failed");
    } 
		return succeeded;
    }

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication succeeded
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * succeeded).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> method), then this method associates a
     * <code>SimplePrincipal</code>
     * with the <code>Subject</code> located in the
     * <code>LoginModule</code>.  If this LoginModule's own
     * authentication attempted failed, then this method removes
     * any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the commit fails.
     *
     * @return true if this LoginModule's own login and commit
     *		attempts succeeded, or false otherwise.
     */
    public boolean commit() throws LoginException {
		if( succeeded == false ) {
		    return false;
		} else {
		    // add a Principal (authenticated identity)
		    // to the Subject
	
		    // assume the user we authenticated is the SimplePrincipal
		    userPrincipal = new SimplePrincipal(username);
		    if( !subject.getPrincipals().contains(userPrincipal) )
				subject.getPrincipals().add(userPrincipal);

				log.debug("\t[SimpleLoginModuleCAS] " +"added SimplePrincipal to Subject");

	
		    // in any case, clean out state
		    username = null;
		 //   password = null;
	
		    commitSucceeded = true;
		    return true;
		}//end if( succeeded == false )
    }//end commit()

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication failed.
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * did not succeed).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> and <code>commit</code> methods),
     * then this method cleans up any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the abort fails.
     *
     * @return false if this LoginModule's own login and/or commit attempts
     *		failed, and true otherwise.
     */
    public boolean abort() throws LoginException {
		if( succeeded == false ) {
		    return false;
		} else if( succeeded == true && commitSucceeded == false ) {
		    // login succeeded but overall authentication failed
		    succeeded = false;
		    username = null;
		    //if( password != null ) password = null;
		    userPrincipal = null;
		} else {
		    // overall authentication succeeded and commit succeeded,
		    // but someone else's commit failed
		    logout();
		}//end if/else
		return true;
    }//end abort()

    /**
     * Logout the user.
     *
     * <p> This method removes the <code>SimplePrincipal</code>
     * that was added by the <code>commit</code> method.
     *
     * <p>
     *
     * @exception LoginException if the logout fails.
     *
     * @return true in all cases since this <code>LoginModule</code>
     *          should not be ignored.
     */
    public boolean logout() throws LoginException {

		subject.getPrincipals().remove(userPrincipal);
		succeeded = false;
		succeeded = commitSucceeded;
		username = null;
	//	if( password != null ) password = null;
		userPrincipal = null;
		return true;
    }//end logout()
}//end class SimpleLoginModule
