
import java.util.*;
import java.io.IOException;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import java.sql.*;

/**
 * <p> This sample LoginModule authenticates users with a password.
 * 
 * <p> This LoginModule maintains two arrays of data. One with
 * user names and the other with passwords. The index for the two
 * arrays is used to map associate a username with a password.
 *
 * <p> If a user successfully authenticates itself,
 * a <code>SimplePrincipal</code> object with the user name
 * is added to the Subject.
 */
public class SimpleLoginModuleSGBD implements LoginModule {
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
    // initial state
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;

/** 
 * <p> This LoginModule recognizes the debug option.
 * If set to true in the login Configuration, debug messages 
 * will be output to the output stream, System.out.
 */
    private boolean debug = false;

    // the authentication status
    private boolean succeeded = false;
    private boolean commitSucceeded = false;

	// login info
	private static final String[] userNames = { "guest", "user1", "user2" };
	private static final String[] passwords = { "sesame", "pass1", "pass2" };
	
	// current user
	private String username;
	private char[] password;
	
    // user's principal object
    private SimplePrincipal userPrincipal;

    /**
     * Initializes the <code>LoginModule</code>.
     *
     * <p>
     *
     * @param subject the <code>Subject</code> to be authenticated. <p>
     *
     * @param callbackHandler a <code>CallbackHandler</code> for communicating
     *			with the end user (prompting for user names and
     *			passwords, for example). <p>
     *
     * @param sharedState shared <code>LoginModule</code> state. <p>
     *
     * @param options options specified in the login
     *			<code>Configuration</code> for this particular
     *			<code>LoginModule</code>.
     */
    public void initialize(Subject subject, CallbackHandler callbackHandler,
			Map sharedState, Map options) {
 
		this.subject = subject;
		this.callbackHandler = callbackHandler;
		this.sharedState = sharedState;
		this.options = options;
	
		// initialize any configured options
		debug = "true".equalsIgnoreCase((String)options.get("debug"));
			
		SimplePrincipal.setDebug( debug );
    }//end initialize()

    /**
     * Authenticate the user by prompting for a user name and password. 
     * The supplied user name and password are then compared to the list
     * of names and passwords (mapped by array index).
     *
     * <p>
     *
     * @return true in all cases since this <code>LoginModule</code>
     *		should not be ignored.
     *
     * @exception FailedLoginException if the authentication fails. <p>
     *
     * @exception LoginException if this <code>LoginModule</code>
     *		is unable to perform the authentication.
     */
    public boolean login() throws LoginException {

		// prompt for a user name and password
		if( callbackHandler == null )
		    throw new LoginException( "Error: no CallbackHandler available " +
				"to garner authentication information from the user" );
	
		Callback[] callbacks = new Callback[2];
		callbacks[0] = new NameCallback( "\nuser name: " );
		callbacks[1] = new PasswordCallback( "password: ", false );
	 
		try {
		    callbackHandler.handle(callbacks);
		    username = ((NameCallback)callbacks[0]).getName();
		    char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
		    if (tmpPassword == null) // treat a NULL password as an empty password
				tmpPassword = new char[0];
		    password = new char[tmpPassword.length];
		    System.arraycopy( tmpPassword, 0,password, 0, tmpPassword.length );
		    ((PasswordCallback)callbacks[1]).clearPassword();	 
		} catch( java.io.IOException ioe ) {
		    throw new LoginException(ioe.toString());
		} catch( UnsupportedCallbackException uce ) {
		    throw new LoginException( "Error: " + uce.getCallback().toString() +
				" not available to authenticate user." );
		}//end try/catch
	
		// print debugging information
		
			log.info( "\t[SimpleLoginModuleSGBD] " +
					"user entered user name: " + username );
			
	
	
		// verify the username/password
		boolean usernameCorrect = false;
		boolean passwordCorrect = false;
		String passwordString = new String( password );
		log.info( "\t[SimpleLoginModuleSGBD] " + "user entered password: "+ passwordString);
		    


    Database database =  Database.getStandard();
    Connection connection = database.getConnection();
    SqlQueries sqlQueries = new SqlQueries() ;

    succeeded = false;
    usernameCorrect = sqlQueries.verifyUser(connection, username);
    //log.info("usernameCorrect = "+usernameCorrect);
	
    if (usernameCorrect && sqlQueries.verifyPassword(connection, username, passwordString)) {
    
      // authentication succeeded!!!
      passwordCorrect = true;
    
	  log.info("[SimpleLoginModuleSGBD] authentication succeeded");
      succeeded = true;
      //return true;
    } else {

      // authentication failed -- clean out state
     
	  log.info("[SimpleLoginModuleSGBD]  authentication failed");
      succeeded = false;
      username = null;
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
      if (!usernameCorrect) {
        throw new FailedLoginException("User Name Incorrect");
      } else {
        throw new FailedLoginException("Password Incorrect");
      }
    } // end if/else usernameCorrect && sqlQueries....

		return succeeded;
    }//end login()

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication succeeded
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * succeeded).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> method), then this method associates a
     * <code>SimplePrincipal</code>
     * with the <code>Subject</code> located in the
     * <code>LoginModule</code>.  If this LoginModule's own
     * authentication attempted failed, then this method removes
     * any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the commit fails.
     *
     * @return true if this LoginModule's own login and commit
     *		attempts succeeded, or false otherwise.
     */
    public boolean commit() throws LoginException {
		if( succeeded == false ) {
		    return false;
		} else {
		    // add a Principal (authenticated identity)
		    // to the Subject
	
		    // assume the user we authenticated is the SimplePrincipal
		    userPrincipal = new SimplePrincipal(username);
		    if( !subject.getPrincipals().contains(userPrincipal) )
				subject.getPrincipals().add(userPrincipal);
	
		    if( debug ) {
				System.out.println("\t[SimpleLoginModule] " +
					"added SimplePrincipal to Subject");
		    }//end if( debug )
	
		    // in any case, clean out state
		    username = null;
		    password = null;
	
		    commitSucceeded = true;
		    return true;
		}//end if( succeeded == false )
    }//end commit()

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication failed.
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * did not succeed).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> and <code>commit</code> methods),
     * then this method cleans up any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the abort fails.
     *
     * @return false if this LoginModule's own login and/or commit attempts
     *		failed, and true otherwise.
     */
    public boolean abort() throws LoginException {
		if( succeeded == false ) {
		    return false;
		} else if( succeeded == true && commitSucceeded == false ) {
		    // login succeeded but overall authentication failed
		    succeeded = false;
		    username = null;
		    if( password != null ) password = null;
		    userPrincipal = null;
		} else {
		    // overall authentication succeeded and commit succeeded,
		    // but someone else's commit failed
		    logout();
		}//end if/else
		return true;
    }//end abort()

    /**
     * Logout the user.
     *
     * <p> This method removes the <code>SimplePrincipal</code>
     * that was added by the <code>commit</code> method.
     *
     * <p>
     *
     * @exception LoginException if the logout fails.
     *
     * @return true in all cases since this <code>LoginModule</code>
     *          should not be ignored.
     */
    public boolean logout() throws LoginException {

		subject.getPrincipals().remove(userPrincipal);
		succeeded = false;
		succeeded = commitSucceeded;
		username = null;
		if( password != null ) password = null;
		userPrincipal = null;
		return true;
    }//end logout()
}//end class SimpleLoginModule
