
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * <p> This class implements the <code>Principal</code> interface
 * and represents a user.
 *
 * <p> Principals such as this <code>SimplePrincipal</code>
 * may be associated with a particular <code>Subject</code>
 * to augment that <code>Subject</code> with an additional
 * identity. Authorization decisions can then be based upon 
 * the Principals associated with a <code>Subject</code>.
 * 
 * @see java.security.Principal
 * @see javax.security.auth.Subject
 */
public class SimplePrincipal implements Principal, java.io.Serializable {
	private static Log log =  LogFactory.getLog("SimplePrincipal");
	/**
		* Debug Flag
		*/
	   private static boolean DEBUG;
    /**
     * The name of the principal
     */
    private String name;

    /**
     * Create a SimplePrincipal with a username.
     *
     * <p>
     *
     * @param name the username for this user.
     *
     * @exception NullPointerException if the <code>name</code>
     *			  is <code>null</code>.
     */
    public SimplePrincipal( String name ) {
		if( name == null )
		    throw new NullPointerException( "illegal null input" );
	
		this.name = name;
		if( DEBUG )  log.info( "\t[SimplePrincipal] Principal " + name + " successfully created." );
    }//end SimplePrincipal( String )

    /**
     * Return the username for this <code>SimplePrincipal</code>.
     *
     * <p>
     *
     * @return the username for this <code>SimplePrincipal</code>
     */
    public String getName() {
		return name;
    }//end getName()

	/**
	 * Sets the debug status to on or off.
	 * 
	 * <p>
	 * 
	 * @param debug flag to set the debug status
	 */
	public static void setDebug( boolean debug ) {
		DEBUG = debug;	
	}//end setDebug( boolean )
	
    /**
     * Return a string representation of this <code>SimplePrincipal</code>.
     *
     * <p>
     *
     * @return a string representation of this <code>SimplePrincipal</code>.
     */
    public String toString() {
		return( "SimplePrincipal:  " + name );
    }//end toString()

    /**
     * Compares the specified Object with this <code>SimplePrincipal</code>
     * for equality.  Returns true if the given object is also a
     * <code>SimplePrincipal</code> and the two SimplePrincipals
     * have the same username.
     *
     * <p>
     *
     * @param o Object to be compared for equality with this
     *		<code>SimplePrincipal</code>.
     *
     * @return true if the specified Object is equal equal to this
     *		<code>SimplePrincipal</code>.
     */
    public boolean equals( Object o ) {
		if( o == null )
		    return false;
	
	        if( this == o )
	            return true;
	 
	        if( !(o instanceof SimplePrincipal) )
	            return false;
	        SimplePrincipal that = (SimplePrincipal)o;
	
		if( this.getName().equals(that.getName()) )
		    return true;
		return false;
    }//end equals()
 
    /**
     * Return a hash code for this <code>SimplePrincipal</code>.
     *
     * <p>
     *
     * @return a hash code for this <code>SimplePrincipal</code>.
     */
    public int hashCode() {
		return name.hashCode();
    }//end hashCode()
}//end class SimplePrincipal
