package com.xor.auth;


import java.security.*;
import javax.security.auth.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/** 

*/

public class AuthUtils {
	private static Log log =  LogFactory.getLog("com.xor.auth");
    // static class
    private AuthUtils() {}

    static public boolean permitted(Subject subj, final Permission p) {
        if ((p == null)) {
            log.info("subj or perm is null");
            return false;
        }
        if (subj == null) {
            subj = new Subject();
        }
        final SecurityManager sm;
	if (System.getSecurityManager() == null) {
	   sm  = new SecurityManager();
  	} else {
	   sm = System.getSecurityManager();
	}
	log.info("trying to auth "+subj+ " with permission "+p);
        try {
            Subject.doAsPrivileged(subj, new PrivilegedExceptionAction() {
                public Object run() { 
					log.debug("sm: "+sm);
                    sm.checkPermission(p);
                    return null;
                }
                },null);
            return true;
        } catch (AccessControlException ace) {
			log.error("exception caught: "+ace);
            return false;
        } catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof SecurityException) {
				log.error("exception caught: "+pae);
            } else {
				log.error("what the hell is this: "+pae);
            }
            return false;
        }

    }
}

