package com.xor.auth;


import javax.security.auth.login.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import java.io.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.univvalenciennes.publi.utils.properties.*;

/** 
adapter class for tagish auth module
*/

public class FileAuth implements Auth{
	private static Log log =  LogFactory.getLog("com.xor.auth");
    private String username;
    private String password;
    private LoginContext lc = null;
    public FileAuth(String username, String password) {
        this.username=username;
        this.password=password;
    }




    public boolean authenticate() {
        try {
        	log.debug("debut authenticate");
            lc = new LoginContext("FileLogin", new MyCallBackHandler(username,password));
			log.debug("ic cree");
            lc.login();
			log.debug("ic login");
        } catch (LoginException le) {
        	log.error("authenticate erreur : "+le);
            return false;
        }
        catch (SecurityException se) {
			log.error("authenticate erreur : "+se);
            return false;
        }
        return true;
    }
    public Subject getSubject() {
        if (lc == null) {
            // either login failed or the authenticate method hasn't been
            // called.
            throw new IllegalStateException("either login failed or the authenticate method hasn't been called.");
        } 
        else {
        		
        	new PropertiesManager("applinews.properties");
        	String temp = PropertiesManager.getProperty("serFile");
        	String url ;
			if(temp.endsWith("/")){
				url = temp+"subject.ser";
			}
			else url = temp+"/subject.ser";
						
            try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(url));
            //"/home/dusart/DEVELOPPEMENT/APPLI_PUBLICATION_WEB/subject.ser"));           
            oos.writeObject(lc.getSubject());
            } catch (IOException ioe) { 
				log.warn("erreur lors de l'criture dans le fichier subject.ser : "+ioe);
            }

            return lc.getSubject();
        }

    }

	/**
	 * @return
	 */
	public String getUsername() {
		return username;
	}

}
