package com.xor.auth;

import java.util.*;
import javax.security.auth.login.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.spi.*;
import java.io.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.univvalenciennes.publi.utils.properties.*;



/** 
adapter class for tagish auth module
*/

public class FileAuthCas implements Auth{
	private static Log log =  LogFactory.getLog("com.xor.auth");
    private String username;
    private String password;
    private LoginContext lc = null;
    private String ticket = null;
	private Subject subject;

    public FileAuthCas(String ticket) {
        this.ticket=ticket;
    }

	public boolean authenticate() {
			try {
				log.info("Appel  MyCallBackHandlerCas");
				MyCallBackHandlerCas cas = new MyCallBackHandlerCas(ticket);
				if(cas.isIsauth()){
					log.info("creation d'un loginContext");
					this.username=cas.getUsername();
					//log.info("fileauthcas username = "+username);

					lc = new LoginContext("FileLogin",cas);			
					lc.login();
					log.info("login via cas ok");
					
		}
			else return false;
			} 
			catch (LoginException le) {
				log.info("LoginException"+le);
				return false;
			}
			catch (SecurityException se) {
				log.info("SecurityException"+se);
				return false;
			}
			return true;
		
	}


    public Subject getSubject() {
        if (lc == null) {
            // either login failed or the authenticate method hasn't been
            // called.
            throw new IllegalStateException("either login failed or the authenticate method hasn't been called.");
        } 
        else {
        		
        	new PropertiesManager("applinews.properties");
        	String temp = PropertiesManager.getProperty("serFile");
        	String url ;
			if(temp.endsWith("/")){
				url = temp+"subject.ser";
			}
			else url = temp+"/subject.ser";
						
            try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(url));
            //"/home/dusart/DEVELOPPEMENT/APPLI_PUBLICATION_WEB/subject.ser"));  
            log.info(lc.getSubject());         
            oos.writeObject(lc.getSubject());
            } catch (IOException ioe) { 
				log.warn("erreur lors de l'criture dans le fichier subject.ser : "+ioe);
            }

            return lc.getSubject();
        }

    }

	/**
	 * @return
	 */
	public String getUsername() {
		return username;
	}

}
