package com.xor.auth;

import javax.security.auth.callback.*;
import javax.servlet.http.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.univvalenciennes.publi.utils.properties.*;

import edu.yale.its.tp.cas.client.ServiceTicketValidator;

/** 
callback handler
*/

public class MyCallBackHandlerCas implements CallbackHandler {
	private static Log log =  LogFactory.getLog("com.xor.auth");
	public void handle(Callback[] callbacks) {
	   for (int i = 0; i< callbacks.length; i++) {
		   if (callbacks[i] instanceof NameCallback) {
			   NameCallback nc = (NameCallback)callbacks[i];
			   nc.setName(username);
		   } 
	   }
   }
    public MyCallBackHandlerCas(HttpSession sess) {
        // yet to be implemented
    }
    private boolean isauth = false;
	private String username;
	  private String ticket;

	public MyCallBackHandlerCas(String ticket) {
		this.isauth = false;
		new PropertiesManager("applinews.properties");
		String CasValidateUrl = PropertiesManager.getProperty("CasValidateUrl");
		String ProxyCallbackUrl = PropertiesManager.getProperty("ProxyCallbackUrl");
		String Service = PropertiesManager.getProperty("Service");
		String typo = PropertiesManager.getProperty("typo");
				   try {
						  ServiceTicketValidator sv = new ServiceTicketValidator();
						   sv.setCasValidateUrl(CasValidateUrl);
						   sv.setProxyCallbackUrl(ProxyCallbackUrl);
						   sv.setService(Service);
						   sv.setServiceTicket(ticket);
						   log.info(" YaleCasContext: Validating ServiceTicket: "+ticket);
						   sv.validate();
							log.info(" YaleCasContext: got response:");
							
						   if (sv.isAuthenticationSuccesful()) {
							log.info("YaleCasContext: authentification successful");
							this.isauth = true;
							
							if(typo.equals("majuscule")) this.username = sv.getUser().toUpperCase() ;
							else this.username = sv.getUser();
							//log.info("mycallbackhandler username = "+username);
					   }
				   }
				   catch (Exception ex){
						log.info("exception YaleCASContext : "+ex);
				   }
				   
	  }
		   	
  


	public String getUsername(){
		return username;	
	}


	/**
	 * @return
	 */
	public boolean isIsauth() {
		return isauth;
	}

}
