package edu.yale.its.tp.cas.client.taglib;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import edu.yale.its.tp.cas.client.*;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 * <p>Tag for indicating authorized proxies for the cas:auth tag.</p>

 * @author Shawn Bayern
 */
public class AuthorizedProxyTag extends BodyTagSupport {

  //*********************************************************************
  // Tag logic

  public int doEndTag() throws JspTagException {
    String authorizedProxy = null;
    if (bodyContent != null)
      authorizedProxy = bodyContent.getString();
    if (authorizedProxy != null)
      authorizedProxy = authorizedProxy.trim();
    if (!(getParent() instanceof AuthTag))
      throw new JspTagException("illegal cas:authorizedProxy outside cas:auth");
    else
      ((AuthTag) getParent()).addAuthorizedProxy(authorizedProxy);
    return EVAL_PAGE;
  }
}
