package edu.yale.its.tp.cas.client.taglib;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import edu.yale.its.tp.cas.client.*;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 * <p>Tag for indicating CAS's "login URL" for the cas:auth tag.</p>

 * @author Shawn Bayern
 */
public class LoginUrlTag extends BodyTagSupport {

  //*********************************************************************
  // Tag logic

  public int doEndTag() throws JspTagException {
    String loginUrl = null;
    if (bodyContent != null)
      loginUrl = bodyContent.getString();
    if (loginUrl != null)
      loginUrl = loginUrl.trim();
    if (!(getParent() instanceof AuthTag))
      throw new JspTagException("illegal cas:loginUrl outside cas:auth");
    else
      ((AuthTag) getParent()).setCasLogin(loginUrl);
    return EVAL_PAGE;
  }
    
}
