package edu.yale.its.tp.cas.client.taglib;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * <p>Logout tag for use with the Yale Central Authentication
 * Service.  Clears the indicated attribute and, if 'scope' is 'session',
 * also invalidates the session.  Finally, redirects to CAS's
 * logout URL.</p>
 *
 * @author Shawn Bayern
 */
public class LogoutTag extends TagSupport {

  //*********************************************************************
  // Internal state

  private String var;					// tag attribute
  private String logoutUrl;				// tag attribute
  private int scope;					// tag attribute

  //*********************************************************************
  // Tag logic

  public int doStartTag() throws JspException {
    try {

      // retrieve the request and response objects
      HttpServletRequest request =
        (HttpServletRequest) pageContext.getRequest();
      HttpServletResponse response =
        (HttpServletResponse) pageContext.getResponse();

      // kill the authentication information
      pageContext.removeAttribute(var, scope);

      // if scope is SESSION_SCOPE, invalidate the session
      if (scope == PageContext.SESSION_SCOPE)
        pageContext.getSession().invalidate();

      // send the redirect
      response.sendRedirect(logoutUrl);

      return SKIP_BODY;
	
    } catch (IOException ex) {
      throw new JspTagException(ex.getMessage());
    }
  }

  public int doEndTag() {
    return SKIP_PAGE;
  }

  //*********************************************************************
  // Accessors

  public void setVar(String var) {
    this.var = var;
  }

  public void setScope(String scope) {
    if (scope.equals("page"))
      this.scope = PageContext.PAGE_SCOPE;
    else if (scope.equals("request"))
      this.scope = PageContext.REQUEST_SCOPE;
    else if (scope.equals("session"))
      this.scope = PageContext.SESSION_SCOPE;
    else if (scope.equals("application"))
      this.scope = PageContext.APPLICATION_SCOPE;
    else
      throw new IllegalArgumentException("invalid scope");
  }

  public void setLogoutUrl(String logoutUrl) {
    this.logoutUrl = logoutUrl;
  }


  //*********************************************************************
  // Constructor and lifecycle management

  public LogoutTag() {
    super();
    init();
  }

  // Releases any resources we may have (or inherit)
  public void release() {
    super.release();
    init();
  }  

  // clears any internal state we might have
  private void init() {
    var = logoutUrl = null;
    scope = PageContext.PAGE_SCOPE;
  }
}
