package edu.yale.its.tp.cas.client.taglib;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import edu.yale.its.tp.cas.client.*;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 * <p>Tag for indicating the current service for the cas:auth tag.</p>

 * @author Shawn Bayern
 */
public class ServiceTag extends BodyTagSupport {

  //*********************************************************************
  // Tag logic

  public int doEndTag() throws JspTagException {
    String service = null;
    if (bodyContent != null)
      service = bodyContent.getString();
    if (service != null)
      service = service.trim();
    if (!(getParent() instanceof AuthTag))
      throw new JspTagException("illegal cas:service outside cas:auth");
    else
      ((AuthTag) getParent()).setService(java.net.URLEncoder.encode(service));
    return EVAL_PAGE;
  }
    
}
