package fr.univvalenciennes.publi.Publication.struts;

import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.News.News;
import fr.univvalenciennes.publi.wsclient.News.NewsService;
import fr.univvalenciennes.publi.wsclient.News.NewsServiceServiceLocator;
import fr.univvalenciennes.publi.wsclient.News.Order;
/**
 * 
 * Description :<br/>
 * Rcupre les informations sur le message que l'utilisateur
 * veut modifier
 * 
 * @version $Id : DoMessAction.java, V1.0, 20 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : DoMessAction<br/>
 * @author  Ronald De la Rberdire  et Sbastien Robin<br/>
 * Doriane Dusart<br/>
 */

public final class DoMessAction extends Action {
	private static Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	
        ////////////////////////////////////////////////////////////////////////////////////
        //
        // Cette fonction dtermine l'action qui sera effectue en des entres
        // qu'elle reoit,c'est une org.apache.struts.action.ActionMapping, une
        // org.apache.struts.action.ActionForm, une avax.servlet.http.HttpServletRequest,
        // une javax.servlet.http.HttpServletResponse
        //
        ////////////////////////////////////////////////////////////////////////////////////
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response)

		throws Exception {
		new PropertiesManager("applinews.properties");
                        ActionErrors errors = new ActionErrors();

                        ///////////////////////////////////////////
                        //rcuprer le bouton actionn
                        ///////////////////////////////////////////
                  
			//String action  = request.getParameter("action");
			String action = "";
			/*
			 * IE et certaines versions de netscape ne renvoyant pas les valeurs 
			 * contenues dans le champ value s'un type image
			 * on doit utiliser des property diffrentes et utiiser l' 
			 * artifice suivant pour pallier  ce bug
			 */
			Enumeration attr = request.getParameterNames();
			String att;
			while(attr.hasMoreElements()){
					att = (String)attr.nextElement();
					log.debug("** DoMessAction - parameter name:" + att + "... value:" + request.getParameter(att));
					if(att.equals("Modifier.x")){ 
						action="Modifier";
					}
					if(att.equals("Imprimer.x")){ 
						action="Imprimer";
					}
		  			if(att.equals("Nouveau.x")){ 
						action="Nouveau";
					}
					if(att.equals("Supprimer.x")){ 
						action="Supprimer";
					}
					if(att.equals("Quitter.x")){ 
						action="Quitter";
					}
			}
			/////////////////////////////////////////
                        //rcuprer le message slectionn
                        /////////////////////////////////////////
                        String newsSelected = request.getParameter("listNews");

                        HttpSession session = request.getSession();

			log.debug("** DoMessAction - Voici le bouton selectionne : " + action);

                        //////////////////////////////////////
                        //si on appuie sur Modifier
                        //////////////////////////////////////
			if("Modifier".equals(action)||"Imprimer".equals(action)){

				log.info("** DoMessAction - Voici le message  modifier ou  imprimer: " + newsSelected);
				session.setAttribute("messageCourant", newsSelected);
				if(newsSelected != null){

                                        ///////////////////////////////////////////////////////////
                                        // Partie concernant la lecture dans la base de donnes
                                        //  travers un WebService
                                        ///////////////////////////////////////////////////////////
					Order order = new Order();
					order.setUidNews(newsSelected);
					NewsServiceServiceLocator serviceLocator = new NewsServiceServiceLocator();

                                        try{
                                        	PropertiesManager prop = new PropertiesManager("applinews.properties");
						NewsService  newsService = serviceLocator.getNews(new URL(prop.getProperty("serviceUrl")+"/News"));
						News news = newsService.orderNews(order);

                                                ///////////////////////////////////////////////////////////////////////////
                                                //Ecrire les lments provenant du WebService dans le formulaire HTML
                                                ///////////////////////////////////////////////////////////////////////////
                        ((NewsForm)form).setUidNews(news.getUidNews());
						((NewsForm)form).setCaption(news.getCaption());
				if(!(Integer.toString(news.getDateEndValidity().get(Calendar.YEAR)).equals("2900"))){
						((NewsForm)form).setDayDEV(Integer.toString(news.getDateEndValidity().get(Calendar.DATE)));
						 ((NewsForm)form).setMonthDEV(Integer.toString((news.getDateEndValidity().get(Calendar.MONTH))+1));
						 ((NewsForm)form).setYearDEV(Integer.toString(news.getDateEndValidity().get(Calendar.YEAR)));
				}
				else {
					((NewsForm)form).setDayDEV("--");
					((NewsForm)form).setMonthDEV("--");
					((NewsForm)form).setYearDEV("--");
				}
				((NewsForm)form).setDayDEB(Integer.toString(news.getDateBeginValidity().get(Calendar.DATE)));
				((NewsForm)form).setMonthDEB(Integer.toString((news.getDateBeginValidity().get(Calendar.MONTH))+1));
				((NewsForm)form).setYearDEB(Integer.toString(news.getDateBeginValidity().get(Calendar.YEAR)));
				
				((NewsForm)form).setJourCreation(Integer.toString(news.getDateCreated().get(Calendar.DATE)));
				((NewsForm)form).setMoisCreation(Integer.toString((news.getDateCreated().get(Calendar.MONTH))+1));
				((NewsForm)form).setAnneeCreation(Integer.toString(news.getDateCreated().get(Calendar.YEAR)));
				
				((NewsForm)form).setJourModification(Integer.toString(news.getDateLastModified().get(Calendar.DATE)));
				((NewsForm)form).setMoisModification(Integer.toString((news.getDateLastModified().get(Calendar.MONTH))+1));
				((NewsForm)form).setAnneeModification(Integer.toString(news.getDateLastModified().get(Calendar.YEAR)));
				
				
	

						((NewsForm)form).setDefaultPriority(Integer.toString(news.getDefaultPriority()));
						/*
						 * rcupration du nom du fichier attache s'il y en a un
						 */
						 try{
							 log.info("DoMessAction : htmlNane= "+news.getHtmlName());
							String temp = news.getHtmlName();
							log.info("DoMessAction : temp= "+(temp==null)+", "+(temp.equals("null"))+", "+(temp.equals("")));
							log.debug("** DoMessAction -  temp : "+temp);
							if(temp==null||temp.equals("null")||temp.equals("")){
								((NewsForm)form).setHtmlName("");
							}
							else{
								
								new PropertiesManager("applinews.properties");
								String path = PropertiesManager.getProperty("uploadUrl");
								String result = temp.replaceAll(path, "");
								log.debug("** DoMessAction -  result : "+result);
								log.info("** DoMessAction -  result : "+result);
								String [] tmp = result.split("/"); 
								result = tmp[1];
								log.info("** DoMessAction -  result : "+result);
								((NewsForm)form).setHtmlName(result);
							}
						 }
						 catch(Exception e){
						 	log.error("** DoMessAction - Erreur lors de la recupration de l'upload : "+e);
						 }
						
						
						((NewsForm)form).setSummary(news.getSummary());
						log.debug("** DoMessAction - summary ok");
						((NewsForm)form).setUrl(news.getUrl());
						log.debug("** DoMessAction - durlate ok");
						//((NewsForm)form).setGifUrl(news.getGifUrl());
						((NewsForm)form).setOwner(news.getOwner());
						log.debug("** DoMessAction - propritaire ok");

					} catch(javax.xml.rpc.ServiceException e) {
						log.error("** DoMessAction - Error1 : " + e);
					} catch(java.rmi.RemoteException e) {
						log.error("** DoMessAction - Error2 : " + e);
						log.error(e.getMessage());
					}catch(Exception e){
						log.error("** DoMessAction - Error3"+e.getMessage());
						return mapping.findForward("viewMess");
					}
					
                                        /////////////////////////////////////////////////////////
                                        // transmettre le message courant  la page suivante
                                        /////////////////////////////////////////////////////////
					session.setAttribute("messageCourant", newsSelected);

					if("Modifier".equals(action)){		
	                                    ////////////////////////////////////////////////////////
                                        // renvoie sur la page relative au raccourci modifMess
                                        ////////////////////////////////////////////////////////
						return mapping.findForward("modifMess");
					}
					else if("Imprimer".equals(action)){
						return mapping.findForward("imprimMess");
					}
				}

                                ///////////////////////////////////
                                //pas de message slectionn
                                ///////////////////////////////////
                                else{
					errors.add(ActionErrors.GLOBAL_ERROR,
                                        new ActionError("error.viewnews.null"));
				}
			}

                        ///////////////////////////////////
                        //si on appuie sur Nouveau
                        ///////////////////////////////////
			else if("Nouveau".equals(action)){

                                return mapping.findForward("registerMess");

                        }

                        /////////////////////////////////////
                        //si on appuie sur Supprimer
                        /////////////////////////////////////
			else if("Supprimer".equals(action)){

				log.info("Voici le message  supprimer : " + newsSelected);
                                if(newsSelected != null){
							        session.setAttribute("messageCourant", newsSelected);
                                        return mapping.findForward("suppMess");
                                }

                                /////////////////////////////////////////////////////
                                //pas de message slectionn ==> message d'erreur
                                /////////////////////////////////////////////////////
                                else{
					errors.add(ActionErrors.GLOBAL_ERROR,
                                        new ActionError("error.viewnews.null"));
				}

                        }
			
                   ////////////////////////////////////
                        //si on appuie sur Quitter
                        ////////////////////////////////////
			else if("Quitter".equals(action)){

				log.debug("** DoMessAction - Retour vers la liste des news");
				return mapping.findForward("listNews");

			}

                        //////////////////////////////////////////////
                        //renvoyer les ventuelles erreurs
                        //////////////////////////////////////////////
			if (!errors.isEmpty()) {
                           saveErrors(request, errors);
                           return (mapping.getInputForward());
                        }

			return null;
		}



}