package fr.univvalenciennes.publi.Publication.struts;


/**
 * Description :<br/>
 * Cette classe est utilise pour produire du code HTML
 * afin de construire l'arborescence de canaux
 * 
 * @version $Id : HTMLGenerator.java, V1.0, 20 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : HTMLGenerator<br/>
 * @author  Ronald De la Rberdire  et Sbastien Robin<br/>
 * Doriane Dusart<br/>
 */

public class HTMLGenerator{

	public String generatedHTMLString;
	
	public HTMLGenerator() {
		init();
	}

	public void init() {
		generatedHTMLString = new String();
	}

        ///////////////////////////////////////////////////////////////
        // Produire les lments qui afficheront la structure selon le
        // niveau dans l'arborescence. Ce niveau est symbolis par le
        // nombre nbr
        //
        // Racine
        // +------Canal1 (nbr=1)
        // +--------------Canal2 (nbr=2)
        // +------Canal3 (nbr=1)
        //
        ///////////////////////////////////////////////////////////////
	public void putMinus(int nbr,String nom) {
		for(int n=0 ; n < nbr ; n++) {
			putString("&#160;&#160;&#160;&#160;&#160;&#160;");
		}
	putImage(nom);
	}
	
	public void putString(String s) {
		generatedHTMLString += s;
	}
	
	public void putStringNewLine(String s) {
		putString(s);
		putString("<p>\n");
	}

        ///////////////////////////////////////////////////////////////
        // Produire le code HTML faisant apparatre un radio bouton
        ///////////////////////////////////////////////////////////////
	public void putRadioButton(String valeur,String nom) {
		putString("<input type=\"radio\" name=\"tree\" value=\""+ valeur+"\" onclick=\"this.form.submit()\"> " + nom + "\n<br>");
		/*"\">" + nom + "\n<br>");*/
	}

	/**
	 * DD
	 * Insere une image de repertoire
	 */
	public void putImage(String nom){
		putString("<img src=\"images/"+nom+"\"/>");		
	}

        /////////////////////////////////////////////////////////////////
        // Retourne la chane de caractre reprsentant le code HTML de
        // l'arbre de canaux
        /////////////////////////////////////////////////////////////////
	public String toString() {
		return generatedHTMLString;
	}

}
