package fr.univvalenciennes.publi.Publication.struts;

import fr.univvalenciennes.publi.Publication.struts.*;
import fr.univvalenciennes.publi.wsclient.Clients.*;
import fr.univvalenciennes.publi.utils.properties.*;
import fr.univvalenciennes.publi.wsclient.canauxClient.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.security.*;



/**
 * 
 * Description : <br/>
 * Rcupre la liste des messages et gnre l'arbre selon le profil de l'utilisateur
 * Une fois l'arbre cr, il est mis en "mmoire" pour viter de le recrer  chaque
 * fois que la liste est demande
 * @version $Id : ListMess.java, V1.2, 11 septembre 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : ListMess<br/>
 * @author  Ronald De la Rberdire  et Sbastien Robin<br/>
 * Doriane Dusart<br/>
 */
public class ListMess{
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	/**
	 * Variable statique utilise pour savoir cette classe a dj t appele pour cette session
	 */
	private  static  ListMess singleton = null;
	/**
	 * Variable qui rcupre la liste des canaux sous forme d'arbre avec les balise HTML de mise en forme 
	 */
	private  String Liste = null;
	/**
	 * Utilisateur de la session en cours
	 */
	private  String user;
	
	
	
	
		
/**
 * Constructeur vide, initilise la classe
 *
 */
	public ListMess(){}
	
	
		
		/**
		 * Lorsque la personne se dloggue il faut appeler cette mthode pour
		 * mettre  jour le singleton et enlever de la mmoire l'arbre
		 * correspondant  la personne
		 */
		public static void setInstance(){
			singleton=null;
		}
		
		/**
		 * Rcupre l'arbre des canaux avec les balises HTML de mise en forme
		 * @return Le code HTML qui met en forme l'arbre de canaux
		 */
		public String getArbre(){
			return this.Liste;
		}
		
	/**
	 * DD
	 * test de recuperation de l'utilisateur
	 * @param user
	 */
	
	public ListMess(String user){
		this.user=user;
		log.debug("ListMess : user = "+this.user);
		listeMessage();
	}
/**
 * Cette mthode cre la liste des canaux attache  l'utilisateur courant
 * et ajoute les balises HTML pour crer l'arbre rsultat
 */
	private void listeMessage() {
		log.debug("------ on est au dbut de listeCanaux ");
		
		/*
		*Activer le WebService
		*/
                ClientCanaux clientCanaux = new ClientCanaux();

               /*
               * Rcuprer la liste des canaux rcupre
               * dans la base de donnes  travers le WebServices
               */
                
                
		Arbre arbre = clientCanaux.getArbre(user);
		log.info(arbre);


               /*
               * Gnrer la structure arborescente des canaux  partir
               * de la liste reue
               */
		TreeGenerator tg = new TreeGenerator(arbre);

               /*
               * Met  jour la variable Liste avec 
               * une chane de caractre reprsentant le code
               * HTML de l'arbre de canaux
               */
                Liste = tg.getHTMLTree();

	}
}


