package fr.univvalenciennes.publi.Publication.struts;


import java.util.Enumeration;
import java.util.GregorianCalendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.News.News;
import fr.univvalenciennes.publi.wsclient.News.NewsService;
import fr.univvalenciennes.publi.wsclient.News.NewsServiceServiceLocator;
import fr.univvalenciennes.publi.wsclient.News.Order;
import java.net.URL;

/**
 * 
 * Description :<br/>
 * Cre un nouveau message en base de donnes, avec ventuellement
 * le traitement d'un fichier attach
 * Utilise le fichier de proprit pour traiter le fichier attach.
 * @version $Id : NewMessAction.java, V1.0, 23 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : NewMessAction<br/>
 * @author  Ronald De la Rberdire  et Sbastien Robin<br/>
 * Doriane Dusart<br/>
 */

public final class NewMessAction extends Action {
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	
	////////////////////////////////////////////////////////////////////////////////////
        //
        // Cette fonction dtermine l'action qui sera effectue en des entres
        // qu'elle reoit,c'est une org.apache.struts.action.ActionMapping, une
        // org.apache.struts.action.ActionForm, une avax.servlet.http.HttpServletRequest,
        // une javax.servlet.http.HttpServletResponse
        //
        ////////////////////////////////////////////////////////////////////////////////////
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response)
		throws Exception {
		new PropertiesManager("applinews.properties");
			log.debug("debut de la procedure " );
			log.debug("On est dans NewsMessAction avec la session :"+request.getSession());
			HttpSession session = request.getSession();
			log.debug("Voici la session : " + session);
		String action = "";
					/*
					 * IE et certaines versions de netscape ne renvoyant pas les valeurs 
					 * contenues dans le champ value s'un type image
					 * on doit utiliser des property diffrentes et utiliser l' 
					 * artifice suivant pour pallier  ce bug
					 */
					Enumeration attr = request.getParameterNames();
					String att;
					while(attr.hasMoreElements()){
							att = (String)attr.nextElement();
							log.debug("parameter name:" + att + "... value:" + request.getParameter(att));
							if(att.equals("Enregistrer.x")){ 
								action="Enregistrer";
							}
							if(att.equals("Abandonner.x")){ 
								action="Abandonner";
							}
					}
					log.debug("Voici le bouton selectionne : " + action);        
			

	if("Enregistrer".equals(action)){
				
					///////////////////////////////////////////////////////////
				    // Partie concernant l'criture dans la base de donnes
					//  travers un WebService
					///////////////////////////////////////////////////////////

									  Order order = new Order();
					NewsServiceServiceLocator serviceLocator = new NewsServiceServiceLocator();
				

					try {
											  /////////////////////////////////////////////////////////////////////////////////
											  //Ecrire les lments provenant du formulaire HTML dans la classe du WebService
											  /////////////////////////////////////////////////////////////////////////////////
						PropertiesManager prop = new PropertiesManager("applinews.properties");
						NewsService  newsService = serviceLocator.getNews(new URL(prop.getProperty("serviceUrl")+"/News"));
						News news = new News();
	if (form instanceof NewsForm) {
		
		String encoding = request.getCharacterEncoding();
				if ((encoding != null) && (encoding.equalsIgnoreCase("iso-8859-1")))
				 {
					 response.setContentType("text/html; charset=iso-8859-1");
				}	
		NewsForm newsform = (NewsForm) form;
			
				 //recuperation du caption
				news.setCaption(newsform.getCaption());
				
		news.setDefaultPriority(Integer.parseInt(newsform.getDefaultPriority()));
		
		
	log.debug("** NewsMessageAction - summary : "+newsform.getSummary());
						news.setSummary(newsform.getSummary());

		log.debug("NewMessAction : url  : "+newsform.getUrl());
						news.setUrl(newsform.getUrl());


		log.debug("** NewsMessageAction - fin : "+newsform.getYearDEV()+"/"+newsform.getMonthDEV()+"/"+newsform.getDayDEV());
			if(!(newsform.getYearDEV().equals("--")) || !(newsform.getMonthDEV().equals("--"))||!(newsform.getDayDEV().equals("--"))){
				news.setDateEndValidity(new GregorianCalendar(Integer.parseInt(newsform.getYearDEV()),Integer.parseInt(newsform.getMonthDEV()),Integer.parseInt(newsform.getDayDEV())+1));

			}	
			else {
				news.setDateEndValidity(null);
			} 


		log.debug("** NewsMessageAction -  debut : "+newsform.getYearDEB()+"/"+newsform.getMonthDEB()+"/"+newsform.getDayDEB());
		if(!(newsform.getYearDEB().equals("--")) || !(newsform.getMonthDEB().equals("--"))||!(newsform.getDayDEB().equals("--"))){	
			news.setDateBeginValidity(new GregorianCalendar(Integer.parseInt(newsform.getYearDEB()),Integer.parseInt(newsform.getMonthDEB()),Integer.parseInt(newsform.getDayDEB())+1));
		}
		else {
			news.setDateBeginValidity(null);
		} 
		
	
			news.setOwner(((User)session.getAttribute("user")).getUsername());
			
			log.debug("owner = "+newsform.getOwner());
			String canal = (String)session.getAttribute("canalcourant");
					 
			log.debug("** NewsMessageAction - file newsform: "+newsform.getLeFichier());
		if((newsform.getLeFichier()!=null)||(!newsform.getLeFichier().equals(""))){			
			FormFile file = newsform.getLeFichier();
			
			log.debug("** NewsMessageAction - file file: "+file.getFileName());
				if((file.getFileName().equals(""))){
					news.setHtmlName("");
				}
				else {			
					UploadFile upload = new UploadFile();				
					try{
					String uploadUrl = upload.Upload(file) ;
					news.setHtmlName(uploadUrl);
					}
					catch(Exception fue){
						log.error("** NewsMessageAction - erreur : "+fue);
					}
				}
		}
	else {
		news.setHtmlName("");	
	}			
	newsService.putNews(news,canal);
	log.debug("** NewsMessageAction - putNews ok"); 
	}	
	} catch(javax.xml.rpc.ServiceException e) {
		log.error("** NewsMessageAction - Error1 : " + e);
	} catch(java.rmi.RemoteException e) {
		log.error("** NewsMessageAction - Error2 : " + e);
	}
	catch(Exception e) {
		log.error("** NewsMessageAction - Error3 : " + e);
	}
	return mapping.findForward("viewMess");
	}
					


			  /////////////////////////////////////////////////
			  //si on appuie sur Abandonner
			  /////////////////////////////////////////////////
else if("Abandonner".equals(action)){

	return mapping.findForward("viewMess");
}

return null;

		}
}
