package fr.univvalenciennes.publi.Publication.struts;

import java.net.URL;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.News.News;
import fr.univvalenciennes.publi.wsclient.News.NewsService;
import fr.univvalenciennes.publi.wsclient.News.NewsServiceServiceLocator;
import fr.univvalenciennes.publi.wsclient.News.Order;

/**
 * 
 * Description :<br/>
 * Supprime le message slectionn ainsi que l'ventuel fichier
 * attach  ce message.
 * @version $Id : SuppMessAction.java, V1.0, 23 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : SuppMessAction<br/>
 * @author  Ronald De la Rberdire  et Sbastien Robin<br/>
 * Doriane Dusart<br/>
 */
public final class SuppMessAction extends Action {
	private static Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response)
		        
		throws Exception {
		new PropertiesManager("applinews.properties");
			//String action  = request.getParameter("action");
			String action = "";
			/*
			 * IE et certaines versions de netscape ne renvoyant pas les valeurs 
			 * contenues dans le champ value s'un type image
			 * on doit utiliser des property diffrentes et utiiser l' 
			 * artifice suivant pour pallier  ce bug
			 */
			Enumeration attr = request.getParameterNames();
			String att;
			while(attr.hasMoreElements()){
					att = (String)attr.nextElement();
					log.debug("** SuppMessAction - parameter name:" + att + "... value:" + request.getParameter(att));
					if(att.equals("Ok.x")){ 
						action="Ok";
					}
					if(att.equals("Abandonner.x")){ 
						action="Abandonner";
					}
			}
			//String news = request.getParameter("listNews");
			HttpSession session = request.getSession();
			String news = (String)session.getAttribute( "messageCourant" );
			
			log.debug("** SuppMessAction - Voici le bouton selectionne : " + action);


			
			if("Ok".equals(action)){

				log.info("** SuppMessAction - Voici le message  supprimer : " + news);
				if(news != null) {
				
					try {
					
						Order order = new Order();
					
						order.setUidNews(news);

					
						NewsServiceServiceLocator serviceLocator = new NewsServiceServiceLocator();
						PropertiesManager prop = new PropertiesManager("applinews.properties");
						NewsService  newsService = serviceLocator.getNews(new URL(prop.getProperty("serviceUrl")+"/News"));
					
					
						News newsfile = newsService.orderNews(order);
						
												/*
												 * Il faut aussi enlever l'eventuel fichier attache
												 */
												String fichier = newsfile.getHtmlName();
												if (fichier!=null){
												log.info("suppmessaction : fichier = "+fichier);
												UploadFile upload = new UploadFile();
												boolean ok = upload.removeFile(fichier);
												}
					
						newsService.deleteNews(order);

						

					
						return mapping.findForward("viewMess");

					} catch(javax.xml.rpc.ServiceException e) {
						log.error("** SuppMessAction - Error1 : " + e);
					} catch(java.rmi.RemoteException e) {
						log.error("** SuppMessAction - Error2 : " + e);
						log.error(e.getMessage());
					}
				}

				return mapping.findForward("viewMess");
			}


			else if("Abandonner".equals(action)){
				
				log.debug("** SuppMessAction - Voici le message qui n'a pas t supprim : " + news);
				return mapping.findForward("viewMess");
				
			}

			return null;
		}
			
		
}
