package fr.univvalenciennes.publi.Publication.struts;
import java.util.*;
import fr.univvalenciennes.publi.wsclient.Clients.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import fr.univvalenciennes.publi.wsclient.*;
import fr.univvalenciennes.publi.wsclient.canauxClient.*;

/**
 * 
 * Description :<br/>
 * Cette classe sert  construire l'arbre de canaux
 *  partir d'une liste qui est une photocopie des champs de la table OrgaCategories
 *
 * Cette liste contient des canaux.Canaux qui reprennent l'architecture 
 * de la table, c'est--dire une String uidcat, une String uidesccat, et 
 * une int ordre
 * L'arbre est construit  partir de cette liste rfrence. 
 * Les diffrents canaux attachs  un utilisateur sont rcuprs,
 * puis des sous-listes sont gnres  partir de ces canaux.
 * @version $Id : TreeGenerator.java, V1.1, 11 septembre 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : TreeGenerator<br/>
 * @author  Ronald De la Rberdire  et Sbastien Robin<br/>
 * Doriane Dusart<br/>
 */
public class TreeGenerator {
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	private Arbre arbre;
	private HTMLGenerator hg;

	private ArrayList canauxRss;
	
	public TreeGenerator(){
		getHTMLTree();
	}
	

	/**
	 *V0 : Etudiants
	 * Le constructeur considere que la racine de l'arbre est
	 * le premier element de la liste
	 *
	 *V1: DD
	 * Le constructeur prend le sous arbre  avec pour nouvelle racine est le canal 
	 * attach a l'utilisateur dans la table catsprofils
	 * Le constructeur rcupre l'arbre complet des canaux, ainsi qu'une liste qui contient
	 * les canaux associs  l'utilisateur.
	 * Il rcupre aussi une liste qui contient les canaux de type RSS qui sont les seuls
	 * ditables.
     */
	public TreeGenerator(Arbre arbre){
			this.arbre = arbre;
			//this.canauxRss = getCanauxRss();
	}

	
	
	private void lireBranche(Branche br, int pos){
		log.debug("TreeGenerator : genArbre : pos= "+pos);
		hg.putString("<tr>\n<td  class=\"publi_texte\">\n");
		int suivant = pos + 1;
		if(br.isFeuille()) hg.putMinus(pos,"Document.gif");
		else hg.putMinus(pos,"Folder.gif");
		
		if(br.isIsRss()) hg.putRadioButton(br.getRacine(),br.getNom());
		else hg.putString(br.getNom());
		
		if(!br.isFeuille()){
		    ArrayList fils = (ArrayList)br.getFilsArrayList();		    
			for(int k=0;k<fils.size();k++){
				Branche tmp = (Branche)fils.get(k);
				lireBranche(tmp,suivant);
			}
		}
		hg.putString("</td>\n</tr>\n");
	}
	
	
	
	
	public String getHTMLTree() {
		this.hg = new HTMLGenerator();
		hg.putString("<table border=\"0\">\n");		
		ArrayList liste = (ArrayList)arbre.getArbreArrayList();
		for(int i=0; i<liste.size();i++){
			Branche br = (Branche)liste.get(i);
			lireBranche(br, 0);
		}
		return hg.toString();
	}

	

	
}
