package fr.univvalenciennes.publi.Publication.struts;


import java.io.*;
import java.util.Calendar;
import java.util.GregorianCalendar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;



/**
 * 
 * Description :<br/>
 * Cette classe donne les diffrentes mthodes utilises pour l'upload
 * de fichier.
 * @version $Id : UploadFile.java, V2.0, 10 septembre 2004<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : UploadFile<br/>
 * @author  Doriane Dusart<br/>
 */

public class UploadFile{
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	/**
	 * Mthode qui permet de tlcharger via FTP un fichier attach 
	 *  un message, et de le stock  un emplacement spcifi dans
	 * le fichier de configuration de l'application.
	 * @param file URI du fichier  attach
	 * @return L'URL du fichier tlcharg. Cette URL est celle qui 
	 * sera donn en lien au message.
	 * Elle est stocke dans la table News, dans la colonne HTMLNAME 
	 */

	public String Upload(FormFile file){
		
		new PropertiesManager("applinews.properties");
		GregorianCalendar greg = new GregorianCalendar();
		greg.setTime(new java.util.Date());

		String propuri = PropertiesManager.getProperty("uploadUri");
		String propurl = PropertiesManager.getProperty("uploadUrl");
		if(!propuri.endsWith("/")) propuri += '/';
		if(!propurl.endsWith("/")) propurl += '/';
		
		String uploadUri = propuri+String.valueOf(greg.get(Calendar.YEAR))+String.valueOf((greg.get(Calendar.MONTH))+1)+String.valueOf(greg.get(Calendar.DAY_OF_MONTH));
		String uploadUrl = propurl+String.valueOf(greg.get(Calendar.YEAR))+String.valueOf((greg.get(Calendar.MONTH))+1)+String.valueOf(greg.get(Calendar.DAY_OF_MONTH));
		
		try {
			//String fileName = file.getFileName();
			String fileName = ChangeNomFichier(file.getFileName());
			
			String contentType = file.getContentType();
			uploadUri = uploadUri+"_"+fileName;
			log.info("\nUploadFile uploadUri : "+uploadUri);							
		
			
			//retrieve the file size
			String size = (file.getFileSize() + " bytes");
			

			//retrieve the file data
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			InputStream stream = file.getInputStream();
		
			
			    //write the file to the file specified
			    OutputStream bos = new FileOutputStream(uploadUri);
			    int bytesRead = 0;
			    byte[] buffer = new byte[8192];
			    while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
				bos.write(buffer, 0, bytesRead);
			    }
			    bos.close();

			//close the stream
			stream.close();    
			file.destroy();
			uploadUrl = uploadUrl +"_"+fileName;
			log.info("\nUploadFile uploadUrl : "+uploadUrl);	

		}
		catch(Exception e){
		    log.error("UploadFile upload error : "+e);
		}
		
		return uploadUrl;
		}
		
		/**
		 * Mthode qui permet d'effacer un fichier attach  un message.
		 * @param url Argument qui donne la valeur du champ HTMLNAME
		 * L'URI du fichier est rcupre  partir de cette URL est du fichier 
		 * de proprits
		 */
		public boolean removeFile(String url){
			new PropertiesManager("applinews.properties");
			boolean ok =false;
		try{
					String path = PropertiesManager.getProperty("uploadUrl");
					if(!path.endsWith("/")) path += '/';
					String result = url.replaceAll(path, "");
					log.debug("removeFile : result = "+result);
					String propuri = PropertiesManager.getProperty("uploadUri");
					if(!propuri.endsWith("/")) propuri += '/';
					path = propuri+result;
					log.info("UploadFile fichier a enlever : "+path);
					File fichier = new File(path);
					ok = fichier.delete();
					if(ok)
						log.info("Fichier enleve avec succes");
					else
						log.info("Le fichier n'a pas ete enleve");
					return ok;
			
		}
		
		catch(Exception f) {
				   log.error("Erreur lors de la suppression du fichier: "+f);
				   return ok;
   		}	
	}

	private String ChangeNomFichier(String nomFichier) {
			//transformation du nom de fichier en retirant toutes
		    //les lettres accentues et caractere speciaux
		    //transformation des espaces en _
		    String temp = nomFichier;
		    temp=temp.replaceAll("[]","A");
		    temp=temp.replaceAll("[]","E");
		    temp=temp.replaceAll("","c");
		    temp=temp.replaceAll("[]","a");
		    temp=temp.replaceAll("[]","e");
		    temp=temp.replaceAll("[]","i");
		    temp=temp.replaceAll("[]","u");
		    temp=temp.replaceAll(" ","_");
		    return temp;
	}
		
}		
