/*
 * $Header: /esup-portail/publi_web/appli_news/source/org/apache/struts/webapp/example/User.java,v 1.1 2003/12/09 13:21:47 doriane.dusart Exp $
 * $Revision: 1.1 $
 * $Date: 2003/12/09 13:21:47 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Struts", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */


package fr.univvalenciennes.publi.Publication.struts;


/**
 * Description :<br/>
 * <p>A <strong>User</strong> which is stored, along with his or her
 * associated {@link Subscription}s, in a {@link UserDatabase}.</p>
 * @since Struts 1.1
 * @version $Revision: 1.1 $ $Date: 2003/12/09 13:21:47 $
 * @version $Id : User.java, V1.0, 23 juin 2003<br/>
 * Copyright (c) 2003 Esup Portail (www.esup-portail.org)<br/>
 * Classe(s) : User<br/>
 * @author Craig R. McClanahan<br/>
 * Ronald De la Rberdire  et Sbastien Robin<br/>
 */

public interface User {


    // ------------------------------------------------------------- Properties


    /**
     * Return the {@link UserDatabase} with which we are associated.
     */
    public UserDatabase getDatabase();


    /**
     * Return the from address.
     */
    public String getFromAddress();


    /**
     * Set the from address.
     *
     * @param fromAddress The new from address
     */
    public void setFromAddress(String fromAddress);


    /**
     * Return the full name.
     */
    public String getFullName();


    /**
     * Set the full name.
     *
     * @param fullName The new full name
     */
    public void setFullName(String fullName);


    /**
     * Return the password.
     */
    public String getPassword();


    /**
     * Set the password.
     *
     * @param password The new password
     */
    public void setPassword(String password);


    /**
     * Return the reply-to address.
     */
    public String getReplyToAddress();


    /**
     * Set the reply-to address.
     *
     * @param replyToAddress The new reply-to address
     */
    public void setReplyToAddress(String replyToAddress);

    /**
     * Find and return all {@link Subscription}s associated with this user.
     * If there are none, a zero-length array is returned.
    */
    public Subscription[] getSubscriptions();

   

    /**
     * Return the username.
     */
    public String getUsername();


    // --------------------------------------------------------- Public Methods

    /**
          * Create and return a new {@link Subscription} associated with this
          * User, for the specified host name.
          *
          * @param host Host name for which to create a subscription
          *
          * @exception IllegalArgumentException if the host name is not unique
          *  for this user
          */
         public Subscription createSubscription(String host);
    
    
         /**
          * Find and return the {@link Subscription} associated with the specified
          * host.  If none is found, return code>null/code>.
          *
          * @param host Host name to look up
          */
         public Subscription findSubscription(String host);
    
    
         /**
          * Remove the specified {@link Subscription} from being associated
          * with this User.
          *
          * @param subscription Subscription to be removed
          *
          * @exception IllegalArgumentException if the specified subscription is not
          *  associated with this User
          */
         public void removeSubscription(Subscription subscription);
    

  

}
