package fr.univvalenciennes.publi.application.admin.affichage;

import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.application.admin.servlets.MenuServlet;
import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;

/**
 * Classe permettant d'afficher la liste des gifs disponibles dans une liste droulante
 * <br>Utilise dans formCreationCat.jsp et formModifCat.jsp
 * @author Nathalie Vauquier
 *
 */
public class ListeGifs implements Serializable {
	static Logger log = Logger.getLogger(MenuServlet.class);

	// classes permettant d'invoquer le web service
	CategoriesServicesService service;
	AdminCategoriesSoapBindingStub stub;

	// Va recevoir le code html gnr
	String listehtml="<select name=\"gifurlExistante\" onChange=\"selectGif(document.images['gifselected']);\">" +
		"<option value=\"\">&nbsp;</option>";

	// gifs qui doit tre selectionn par dfaut
	String selected = null;

	/**
	 * Construit la liste des gifs
	 * @throws Exception
	 */
	public ListeGifs() throws Exception {
		new PropertiesManager("applinews.properties");
		try {
			// Cration d'un stub permettant d'invoquer les mthodes du Web Service
			service = new CategoriesServicesServiceLocator();
			stub = (AdminCategoriesSoapBindingStub) service.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
			
			// construction de la liste
			constrListe();
			
			// fermeture du web service
//			stub.close();
		} catch (Exception e) {
//			if(stub!=null)	stub.close();
			log.error("ListeGifs - erreur : " + e.getMessage());
			throw (Exception)e;
		}
	}
	
	/**
	 * Construit la liste des gifs avec un gif selectionn
	 * @param selected
	 * @throws Exception
	 */
	public ListeGifs(String selected) throws Exception {
		new PropertiesManager("applinews.properties");

		try {
			// Cration d'un stub permettant d'invoquer les mthodes du Web Service
			service = new CategoriesServicesServiceLocator();
			stub = (AdminCategoriesSoapBindingStub) service.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));

			this.selected = selected;

			// constuction de la liste
			constrListe();
			
			// fermeture du web service
//			stub.close();
		} catch (Exception e) {
//			if(stub!=null)	stub.close();
			log.error("ListeGifs - erreur : " + e.getMessage());
			throw (Exception)e;
		}
	}

	
	/**
	 * Gnre le code html permettant d'afficher la liste des gifs
	 * @throws Exception
	 */
	public void constrListe() throws Exception {
		try {
			// on rcupre la liste des gifs
			Vector v = stub.getAllAvailableGifs();
			for (Enumeration e = v.elements(); e.hasMoreElements();) {
				String url = (String)e.nextElement();
				if(!url.equals("null")){
					if(url.equals(selected))
						listehtml += "<option selected value=\"" + url + "\">" + url + "</option>";
					else
						listehtml += "<option value=\"" + url + "\">" + url + "</option>";
				}
			}
			listehtml += "</select>";
		} catch (Exception e) {
//			if(stub!=null)	stub.close();
			log.error("ListeGifs - erreur : " + e.getMessage());
			throw (Exception)e;
		}
	}
	
	/**
	 * @return le code html gnr correspondant  la liste droulante
	 */
	public String getListe() {
		return listehtml;
	}

}

