package fr.univvalenciennes.publi.application.admin.affichage;

import java.io.Serializable;
import java.net.URL;
import java.util.*;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;
import fr.univvalenciennes.publi.utils.properties.*;

/**
 * Classe permettant d'afficher la liste des profils dans une liste droulante
 * <br>Utilise dans listeProfils.jsp et formChangerProfil.jsp
 * @author Nathalie Vauquier
 *
 */
public class ListeProfils implements Serializable {
	static Logger log = Logger.getLogger(ListeProfils.class);
	
	// classes permettant d'invoquer le web service
	ProfilsServicesService service;
	AdminProfilsSoapBindingStub stub;

	// Va recevoir le code html gnr
	public String listehtml="";
	
	// les profils qui doivent tre selectionns
	public String uidSelected;
	
	/**
	 * Construit la liste des profils
	 * @throws Exception
	 */
	public ListeProfils(String uidProf) throws Exception {
		this.uidSelected = uidProf;
		new PropertiesManager("applinews.properties");
		try {
			// Cration d'un stub permettant d'invoquer les mthodes du Web Service
			service = new ProfilsServicesServiceLocator();
			stub = (AdminProfilsSoapBindingStub) service.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));

			// construction de la liste
			constrListe();
			
			// fermeture du web service
			stub.close();
		} catch (Exception e) {
			if(stub!=null)	stub.close();
			log.error("ListeProfils - erreur : " + e.getMessage());
			throw (Exception)e;
		}
	}

	/**
	 * Construit la liste des profils
	 * @throws Exception
	 */
	public ListeProfils() throws Exception {
		this("");
	}

	
	/**
	 * Gnre le code html permettant d'afficher la liste des profils
	 * @throws Exception
	 */
	public void constrListe() throws Exception {
		try {
			// on rcupre les profils
			Vector v = stub.getAllProfils();
			
			// ouverture de la liste
			listehtml += "<select size=1 name=\"uidprofselect\" >";
			
			for (Enumeration e = v.elements(); e.hasMoreElements();) {
				String uidProf = (String)e.nextElement();
				// si le caption est renseign on affiche le caption, sinon l'uid
				String caption = stub.getCaptionProfils(uidProf); 
				caption = (caption.length()>0?caption:uidProf);
				listehtml += "<option value=\"" + uidProf + "\" "+(this.uidSelected.equals(uidProf)?"selected":"")+" >"+caption ;
			}
			
			// fermeture de la liste
			listehtml += "</select>";
		} catch (Exception e) {
			if(stub!=null)	stub.close();
			log.error("ListeProfils - erreur : " + e.getMessage());
			throw (Exception)e;
		}
	}
	
	/**
	 * @param uidProf
	 * @return
	 */
	/*private boolean isSelected(String uidProf) {
		for(Enumeration e=this.uidSelected.elements();e.hasMoreElements();) {
			if(uidProf.equals((String)e.nextElement()))	return true;
		}
		return false;
	}*/

	/**
	 * @return le code html gnr correspondant  la liste droulante
	 */
	public String getListe() {
		return listehtml;
	}

}
