package fr.univvalenciennes.publi.application.admin.affichage;

import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.AdminProfilsSoapBindingStub;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.ProfilsServicesService;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.ProfilsServicesServiceLocator;

/**
 * Classe permettant d'afficher la liste des utilisateurs dans une liste droulante
 * <br>Utilise dans listeUtilisateurs.jsp
 * @author Nathalie Vauquier
 *
 */
public class ListeUtilisateurs implements Serializable {
	static Logger log = Logger.getLogger(ListeUtilisateurs.class);

	// classes permettant d'invoquer le web service
	ProfilsServicesService service;
	AdminProfilsSoapBindingStub stub;

	// Profil dont on veut afficher les utilisateurs
	public String uidProf;

	// Va recevoir le code html gnr
	public String listehtml="";

	/**
	 * Construit la liste des utilisateurs d'un profil
	 * @param uidProf	uid du profil dont on veut afficher la liste
	 * @throws Exception
	 */
	public ListeUtilisateurs(String uidProf) throws Exception {
		try {
			this.uidProf = uidProf;

			// Cration d'un stub permettant d'invoquer les mthodes du Web Service
			service = new ProfilsServicesServiceLocator();
			new PropertiesManager("applinews.properties");
			stub = (AdminProfilsSoapBindingStub) service.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));

			// construction de la liste
			constrListe();
			
			// fermeture du web service
			stub.close();
		} catch (Exception e) {
			if(stub!=null)	stub.close();
			log.error("ListeUtilisateurs - erreur : " + e);
			throw (Exception)e;
		}
	}
	
	public ListeUtilisateurs() throws Exception {
		this("");
	}
		
	
	/**
	 * Gnre le code html permettant d'afficher la liste des utilisateurs
	 * @throws Exception
	 */
	public void constrListe() throws Exception {
		try {
			Vector v;
			if(this.uidProf.equals("")){
				v = stub.getAllUsers();
			} else {
				// on rcupre la liste des utilisateurs
				v = stub.getProfilUsers(uidProf);
			}
			
			// dbut de la liste droulante
			listehtml += "<select name=\"uiduserselect\">";
			for (Enumeration e = v.elements(); e.hasMoreElements();) {
				// ajout d'un utilisateur
				String uidUser = (String)e.nextElement();
				String nomcomplet = stub.getNomCompletUser(uidUser); 
				nomcomplet = (nomcomplet.length()>0?nomcomplet:uidUser);
				listehtml += "<option value=\"" + uidUser + "\" onclick=\"\"> " + nomcomplet ;
			}
			
			// fin de la liste
			listehtml += "</select>";
		} catch (Exception e) {
			if(stub!=null)	stub.close();
			log.error("ListeUtilisateurs constrListe() - erreur : " + e);
			throw (Exception)e;
		}
	}
	
	/**
	 * @return le code html gnr correspondant  la liste droulante
	 */
	public String getListe() {
		return listehtml;
	}
	
	public void constrListeUL() throws Exception {
		try {
			Vector v;
			if(this.uidProf.equals("")){
				v = stub.getAllUsers();
			} else {
				// on rcupre la liste des utilisateurs
				v = stub.getProfilUsers(uidProf);
			}
			
			// dbut de la liste droulante
			listehtml += "<ul>";
			for (Enumeration e = v.elements(); e.hasMoreElements();) {
				// ajout d'un utilisateur
				String uidUser = (String)e.nextElement();
				String nomcomplet = stub.getNomCompletUser(uidUser); 
				nomcomplet = (nomcomplet.length()>0?nomcomplet:uidUser);
				listehtml += "<li> " + nomcomplet +"</li>" ;
			}
			
			// fin de la liste
			listehtml += "</ul>";
		} catch (Exception e) {
			if(stub!=null)	stub.close();
			log.error("ListeUtilisateurs constrListe() - erreur : " + e);
			throw (Exception)e;
		}
	}
	/**
	 * @return le code html gnr correspondant  la liste droulante
	 */
	public String getListeUL() {
		return listehtml;
	}	
	

}
