package fr.univvalenciennes.publi.application.admin.affichage.jenkov;

import com.jenkov.tags.tree.itf.ITreeIteratorElement;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class NodeBaseTag extends TagSupport {

    protected String node = null;

     public String getNode(){
         return this.node;
     }

     public void setNode(String node){
         this.node = node;
     }

     protected void validateAttributes() throws JspException{
         if(getNode() == null)
             throw new JspException("Attribute node must not be null");
     }

     protected ITreeIteratorElement getElement() throws JspException{
         validateAttributes();
         ITreeIteratorElement element =
                 (ITreeIteratorElement) pageContext.getSession().getAttribute(getNode());
         if(element == null){
             throw new JspException("Node retrieved from session was null");
         }
         return element;
     }

     protected void write(String text) throws JspException{
        try{
            pageContext.getOut().write(text);
        } catch (IOException e) {
            throw new JspException("Could not write to JspWriter", e);
        }
    }
}
