package fr.univvalenciennes.publi.application.admin.affichage.jenkov;

import com.jenkov.tags.tree.itf.*;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tree implements ITree{
	protected boolean   singleSelectionMode = false;
	protected Set       expanded = new TreeSet();
	protected Set       selected = new TreeSet();
	protected ITreeNode root     = null;

	protected List      expandListeners   = new ArrayList();
	protected List      collapseListeners = new ArrayList();
	protected List      selectListeners   = new ArrayList();
	protected List      unselectListeners = new ArrayList();
	
	public String uid;
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");
	
	public Tree(String uidUser){	
		log.debug("** Tree debut");
		CategoriesServicesService service;
		AdminCategoriesSoapBindingStub stub=null;
		new PropertiesManager("applinews.properties");
		ITreeNode   treeRoot        = new TreeNode("treeRoot", "Vos Canaux", "root");
		log.debug("** Tree treeRoot : "+treeRoot);
		service = new CategoriesServicesServiceLocator();
		try {
			stub = (AdminCategoriesSoapBindingStub) service.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
			log.debug("** Tree stub");
		} catch (Exception e) {
			log.error("** Tree Erreur lors de la rcupration du stub : "+e);
		}
		
		// on rcupre les catgories attaches  l'utilisateur
		Vector v;
		try {
			log.debug("** Tree on rcupre les catgories attaches  l'utilisateur");
			v = stub.getAllCategories(uidUser);
			log.debug("** Tree vecteur taille = "+v.size() + " 1er element  = "+v.firstElement());
			for (Enumeration e = v.elements(); e.hasMoreElements();) {
				String uidCat = (String)e.nextElement();
				log.debug("nouveau noeud : "+uidCat);
				// on affiche le champ caption s'il est renseign sinon l'uid
				String caption = stub.getCaptionCategories(uidCat); 
				caption = (caption.length()>0?caption:uidCat);
				TreeNode   canal = new TreeNode("null|"+uidCat,caption,"canal");
				treeRoot.addChild(canal);
			}
		} catch (RemoteException e1) {
			// TODO Bloc catch auto-gnr
			e1.printStackTrace();
			log.error("** Tree Erreur lors de la recuperation des categories : "+e1);
		}
		this.setRoot(treeRoot);
		this.collapse(treeRoot.getId());
		this.select(treeRoot.getId());
	}

	// TODO : ajouter des ifs et utiliser systmatiquement ce constructeur
	public Tree(String type, String uid){
		new PropertiesManager("applinews.properties");

		if(type.equals("profil")){
			this.uid=uid;
			ProfilsServicesService profService;
			AdminProfilsSoapBindingStub profStub=null;
			CategoriesServicesService catService;
			AdminCategoriesSoapBindingStub catStub=null;
	
			ITreeNode   treeRoot        = new TreeNode("treeRoot", "Canaux de "+uid, "root");

			profService = new ProfilsServicesServiceLocator();
			try {
				profStub = (AdminProfilsSoapBindingStub) profService.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));
			} catch (Exception e) {
			}
			
			catService = new CategoriesServicesServiceLocator();
			try {
				catStub = (AdminCategoriesSoapBindingStub) catService.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
			} catch (Exception e) {
			}

			// on rcupre les catgories attaches au profil
			Vector v;
			try {
				v = profStub.getCategoriesAttachees(uid);
				for (Enumeration e = v.elements(); e.hasMoreElements();) {
					String uidCat = (String)e.nextElement();
					// on affiche le champ caption s'il est renseign sinon l'uid
					String caption = catStub.getCaptionCategories(uidCat); 
					caption = (caption.length()>0?caption:uidCat);
					TreeNode   canal = new TreeNode("null|"+uidCat,caption,"canalAttache");
					treeRoot.addChild(canal);
				}
			} catch (RemoteException e1) {
				// TODO Bloc catch auto-gnr
				e1.printStackTrace();
			}
			this.setRoot(treeRoot);
			this.collapse(treeRoot.getId());
		}
		
	}
	
	public ITreeNode getRoot() {
		return this.root;
	}

	public void setRoot(ITreeNode node) {
		this.root = node;
	}

	public ITreeNode findNode(String treeNodeId) {
		return findNode(getRoot(), treeNodeId);
	}

	protected ITreeNode findNode(ITreeNode treeNode, String treeNodeId){
		if(treeNode.getId().equals(treeNodeId)){
			return treeNode;
		}

		Iterator children = treeNode.getChildren().iterator();
		while(children.hasNext()){
			ITreeNode child = (ITreeNode) children.next();
			ITreeNode match = findNode(child, treeNodeId);
			if( match != null){
				return match;
			}
		}
		return null;
	}
	
	public void refreshNodesEndWith(String token){
		log.debug("Tree ok1 - token : "+token);		
		Iterator children = root.getChildren().iterator();
		log.debug("Tree ok2");		
		while(children.hasNext()){
			log.debug("Tree ok3");		
			TreeNode child = (TreeNode) children.next();
			log.debug("Tree ok4 - cat : "+child.getId());		
			refreshNodesEndWith(child,token);
			log.debug("Tree ok5");		
		}

	}

	public void refreshNodesEndWith(TreeNode canal, String token){
		if(canal.getId().endsWith(token)){
			canal.setChildren();
		}
		
		Iterator children = canal.getChildren().iterator();
		while(children.hasNext()){
			TreeNode child = (TreeNode) children.next();
			refreshNodesEndWith(child,token);
		}
	}

	public Set findNodes(Set treeNodeIds) {
		Set treeNodes = new HashSet();
		findNodes(getRoot(), treeNodeIds, treeNodes);
		return treeNodes;
	}

	protected void findNodes(ITreeNode treeNode, Set treeNodeIds, Set treeNodes){
		if(treeNodeIds.contains(treeNode.getId())){
			treeNodes.add(treeNode);
		}

		Iterator children = treeNode.getChildren().iterator();
		while(children.hasNext()){
			findNodes((ITreeNode) children.next(), treeNodeIds, treeNodes);
		}
	}

	public boolean isExpanded(String treeNodeId){
		return this.expanded.contains(treeNodeId);
	}

	public void expand(String treeNodeId) {
		// dploiement d'un canal
		this.expanded.add(treeNodeId);
		if(this.expandListeners.size() > 0){
			ITreeNode expandedNode = findNode(treeNodeId);
			
			List children;
			if( (expandedNode!=null) && ((children=expandedNode.getChildren())!=null)) {
				for(int i=0;i<children.size();i++) {
					TreeNode childNode = (TreeNode) children.get(i);
					childNode.setChildren();
				}
			}

			Iterator iterator = this.expandListeners.iterator();
			while(iterator.hasNext()){
				((IExpandListener) iterator.next()).nodeExpanded(expandedNode, this);
			}
		}
		

	}

	public void collapse(String treeNodeId) {
		this.expanded.remove(treeNodeId);
		if(this.collapseListeners.size() > 0){
			ITreeNode collapsedNode = findNode(treeNodeId);
			Iterator iterator = this.collapseListeners.iterator();
			while(iterator.hasNext()){
				((ICollapseListener) iterator.next()).nodeCollapsed(collapsedNode, this);
			}
		}

	}

	public Set getExpandedNodes() {
		return findNodes(this.expanded);
	}

	public void addExpandListener(IExpandListener expandListener) {
		this.expandListeners.add(expandListener);
	}

	public void removeExpandListener(IExpandListener expandListener) {
		this.expandListeners.remove(expandListener);
	}

	public void addCollapseListener(ICollapseListener collapseListener) {
		this.collapseListeners.add(collapseListener);
	}

	public void removeCollapseListener(ICollapseListener collapseListener) {
		this.collapseListeners.remove(collapseListener);
	}

	public boolean isSelected(String treeNodeId) {
		return this.selected.contains(treeNodeId);
	}

	public void select(String treeNodeId) {
		if(isSingleSelectionMode()){
			unSelectAll();
		}
		this.selected.add(treeNodeId);

		if(this.selectListeners.size() > 0){
			ITreeNode selectedNode = findNode(treeNodeId);
			Iterator iterator = this.selectListeners.iterator();
			while(iterator.hasNext()){
				((ISelectListener) iterator.next()).nodeSelected(selectedNode, this);
			}
		}
	}

	public void unSelect(String treeNodeId) {
		this.selected.remove(treeNodeId);
		if(this.unselectListeners.size() > 0){
			ITreeNode unselectedNode = findNode(treeNodeId);
			Iterator iterator = this.unselectListeners.iterator();
			while(iterator.hasNext()){
				((IUnselectListener) iterator.next()).nodeUnselected(unselectedNode, this);
			}
		}
	}


	public void unSelectAll() {
		Iterator iterator =  this.selected.iterator();
		while(iterator.hasNext()){
			unSelect((String) iterator.next());
		}
	}

	public Set getSelectedNodes() {
		return findNodes(this.selected);
	}

	public void setSingleSelectionMode(boolean mode) {
		this.singleSelectionMode = mode;
	}

	public boolean isSingleSelectionMode(){
		return this.singleSelectionMode;
	}

	public void addSelectListener(ISelectListener selectListener) {
		this.selectListeners.add(selectListener);
	}

	public void removeSelectListener(ISelectListener selectListener) {
		this.selectListeners.remove(selectListener);
	}

	public void addUnselectListener(IUnselectListener unselectListener) {
		this.unselectListeners.add(unselectListener);
	}

	public void removeUnselectListener(IUnselectListener unselectListener) {
		this.unselectListeners.remove(unselectListener);
	}

	public Iterator iterator(boolean includeRootNode) {
		return new TreeIterator(this, includeRootNode);
	}
	/**
	 * @return
	 */
	public String getUid() {
		return uid;
	}

}
