package fr.univvalenciennes.publi.application.admin.affichage.jenkov;

import com.jenkov.tags.tree.itf.ITreeNode;

import fr.univvalenciennes.publi.utils.properties.PropertiesManager;
import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNode implements ITreeNode {
	private Log log =  LogFactory.getLog("org.apache.struts.webapp.Example");

	protected String name     = "";
	protected String id       = "";
	protected String type     = "";
	protected List   children = new ArrayList();

	public TreeNode(String id, String name){
		new PropertiesManager("applinews.properties");
		setId(id);
		setName(name);
	}

	public TreeNode(String id, String name, String type){
		new PropertiesManager("applinews.properties");
		setId(id);
		setName(name);
		this.type = type;
	}

	public void setChildren() {
		new PropertiesManager("applinews.properties");
		CategoriesServicesService service;
		AdminCategoriesSoapBindingStub stub=null;

		service = new CategoriesServicesServiceLocator();
		try {
			stub = (AdminCategoriesSoapBindingStub) service.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
		} catch (Exception e) {
			log.error("** TreeNode - setChildren erreur : "+e);
		}		
		Vector v;
		try {
			String uidCat;
			int i = id.indexOf("|");
			uidCat = id.substring(i + 1, id.length());

			v = stub.getCategoriesFilles(uidCat);
			log.debug("** TreeNode - setChildren nombre categories : "+v.size());
			for (Enumeration e = v.elements(); e.hasMoreElements();) {
				String uidCatChild = (String)e.nextElement();
				ITreeNode node = findNode(uidCat+"|"+uidCatChild);
				log.debug("** TreeNode - setChildren ITreenode cree pour uidCatChild : "+uidCatChild);
				if(node==null){
					// on affiche le champ caption s'il est renseign sinon l'uid
					log.debug("** TreeNode - setChildren ITreenode est null pour uidCatChild : "+uidCatChild);
					String caption = stub.getCaptionCategories(uidCatChild);
					log.debug("** TreeNode - setChildren caption = "+caption);
					caption = (caption.length()>0?caption:uidCatChild);
					ITreeNode   canal = new TreeNode(uidCat+"|"+uidCatChild,caption,"canal");
					log.debug("** TreeNode - setChildren ITreeNode canal cree pour uidCatChild : "+uidCatChild);
					this.addChild(canal);
				}
			}
		} catch (RemoteException e1) {
			// TODO Bloc catch auto-gnr
			e1.printStackTrace();
			log.error("** TreeNode - setChildren erreur : "+e1);
		}
	}
	
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public void addChild(ITreeNode node) {
		this.children.add(node);
		log.debug("** TreeNode - addChild noeud ajoute, taille de children "+children.size());
	}

	public void removeChild(ITreeNode node) {
		this.children.remove(node);
	}

	public void removeAllChildren() {
		this.children.clear();
	}

	public List getChildren() {
		return this.children;
	}

	public boolean hasChildren() {
		return getChildren().size() > 0;
	}

	public boolean equals(Object o){
		ITreeNode node = (ITreeNode) o;
		if(!this.id.equals(node.getId())){
			return false;
		}

		return true;
	}

	public String toString(){
		StringBuffer buffer = new StringBuffer();
		buffer.append("(id: ");
		buffer.append(getId());
		buffer.append(",    name: ");
		buffer.append(getName());
		buffer.append(",    type: ");
		buffer.append(")");

		return buffer.toString();
	}

	protected ITreeNode findNode(String treeNodeId){
		Iterator children = this.getChildren().iterator();
		while(children.hasNext()){
			ITreeNode child = (ITreeNode) children.next();
			if(child.getId().equals(treeNodeId)){
				return child;
			}
		}
		return null;
	}

}
