package fr.univvalenciennes.publi.application.admin.servlets;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.rpc.ServiceException;

import org.apache.commons.fileupload.*;
import org.apache.log4j.Logger;

import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;

import fr.univvalenciennes.publi.utils.properties.*;

import java.net.URL;

/**
 * Cette servlet traite le formulaire de la jsp formCreationCat.jsp.
 * Ce formulaire possdant un champ <input type=file> afin d'uploader 
 * une icne, il doit possder l'attribut enctype="multipart/form-data" 
 * et doit donc tre trait diffremment des autres formulaires 
 * @author Nathalie Vauquier
 *
 */
public class CreationCatServlet extends HttpServlet {
	static Logger log = Logger.getLogger(MenuServlet.class);
	
	CategoriesServicesService catService;
	AdminCategoriesSoapBindingStub catStub;
	ProfilsServicesService profService;
	AdminProfilsSoapBindingStub profStub;
	PrintWriter  out;
	
	public void  doPost (HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException{
		new PropertiesManager("applinews.properties");
		try{
			// obtention d'un flux de sortie
			out = res.getWriter ( );
			
			// on rcupre le stub vers le ws d'administration des catgories s'il est encore disponible
			// sinon, on en cre un nouveau et on le met en sesion
			catStub = (AdminCategoriesSoapBindingStub) req.getSession().getAttribute("catstub");
			if(catStub==null){
				try {
					catService = new CategoriesServicesServiceLocator();
					catStub = (AdminCategoriesSoapBindingStub) catService.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
				} catch (ServiceException e) {
					log.error("CreationCatServlet - ouverture de catStub - erreur : " + e.getMessage());
					throw (Exception)e;
				}
				req.getSession().setAttribute("catstub", catStub);
			}
			
			// champs du formulaire
			String uidCatMere="",uidCat="",caption="",summary="",gifurl="",url="";
			boolean editable=false;
			
			// permet de parser la requte
			DiskFileUpload upload = new DiskFileUpload();
			
			// liste des items du formulaire
			List items;
	
			try {
				// on rcupre les items du formulaire
				items = upload.parseRequest(req);
				Iterator iter = items.iterator();
				
				while (iter.hasNext()) {
					FileItem item = (FileItem) iter.next();
					if (item.isFormField()) {
						// pour un field "traditionnel" (<input type=...>)
						String name = item.getFieldName();
						if(name.equals("uidcatmere")){
							uidCatMere = item.getString().toUpperCase();
						} else if(name.equals("uidcat")){
							uidCat = item.getString().toUpperCase();
						} else if(name.equals("caption")){
							caption = item.getString();
						} else if(name.equals("summary")){
							summary = item.getString();
						} else if(name.equals("gifurlExistante")){
							gifurl = item.getString();
						} else if(name.equals("editable")){
							editable = item.getString().equals("o");
						} 
					} else {
						// pour un field de type file (<input type=file>)
						String fieldName = item.getFieldName();
						if((fieldName.equals("gifurlNouvelle"))&&(item.getString().trim().length()>0)){
							// UPLOAD D'UNE NOUVELLE ICONE
							
							// on rcupre l'adresse o on stocke les icnes dans le fichier de proprits 
							new PropertiesManager("applinews.properties");
							String uploadUri = PropertiesManager.getProperty("uploadGifUri");
							String uploadUrl = PropertiesManager.getProperty("uploadGifUrl");
							
							// on donne un nom  cette icne
							String gifName= "Logo-" + uidCat + ".gif";
							
							// adresse du fichier  crer
							String gifUri= uploadUri + gifName;
							
							if(!item.getContentType().equals("image/gif")){
								// l'image n'est pas un gif
								erreur("nonGif",null,req,res);
								break;
							} else if (item.getSize()>15000){
								// l'image est trop grosse
								erreur("gifTooBig",null,req,res);
								break;
							} else {
								// ouverture d'un fichier
								File f = new File(gifUri);
								
								int i=0;
								while(f.exists()){
									// il existe dj une icne possdant ce nom
									i++;
									gifName = "Logo-" + uidCat + "_" + i + ".gif";	
									gifUri = uploadUri + gifName;
									File tmp = new File(gifUri);
									f=tmp;
								}
								
								gifurl = uploadUrl + gifName;
								
								// cration du nouveau fichier
								item.write(f);
							}
						}
					}
				}
					
	
				if(caption.length()==0)	caption=uidCat;
	
				if (catStub.catExiste(uidCat)) {
					// il existe dj une catgorie possdant cet uid
					erreur("categorie existe",uidCat,req,res);
				} else {
					// cration de la catgorie dans la base
					catStub.createCategories(uidCat,caption,summary,gifurl);
					// cration du lien avec la catgorie mre
					catStub.createOrgaCategories(uidCatMere,uidCat);
					
					// publication du canal s'il est ditable
					if(editable) {
						profStub = (AdminProfilsSoapBindingStub) req.getSession().getAttribute("profstub");
						if(profStub==null){
							try {
								profService = new ProfilsServicesServiceLocator();
								profStub = (AdminProfilsSoapBindingStub) profService.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));
							} catch (ServiceException e) {
								log.error("CreationCatServlet - ouverture de profStub - erreur : " + e.getMessage());
								throw (Exception)e;
							}
							req.getSession().setAttribute("profstub", catStub);
						}
						// on rcupre le profil de l'utilisateur
						//String owner = profStub.getProfil((String)req.getSession().getAttribute("uiduser"));
						String owner = (String)req.getSession().getAttribute("uiduser");
						catStub.publishAsRss(uidCat,owner);
					}
					
					// mise  jour des arbres affichs
					req.getSession().setAttribute("canaux",null);
					req.getSession().setAttribute("arbre",null);
					
					// retour  la liste des catgories
					getServletConfig().getServletContext().getRequestDispatcher("/listeCategories.jsp").forward(req, res); 
				}
				
			}catch(Exception e){
				log.error("CreationCatServlet - erreur : " + e.getMessage());
				throw (Exception)e;
			}
			// fermeture du flux de sortie
			out.close();
		} catch (Exception e){
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.html");
			if(out!=null)		out.close();
		}
	}
	
	public void erreur(String er,String uid,HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException{
		if(er.equals("categorie existe")){
			req.setAttribute("message","Il existe dj un canal possdant l'identifiant \"" + uid + "\". <br>Veuillez choisir un autre identifiant.");
			req.setAttribute("retour","listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res); 
		}
		if(er.equals("nonGif")){
			req.setAttribute("message","L'icne associe  votre canal doit tre au format gif.");
			req.setAttribute("retour","listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res); 
		}
		if(er.equals("gifTooBig")){
			req.setAttribute("message","L'icne associe est trop grande.");
			req.setAttribute("retour","listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res); 
		}
		if(er.equals("boucle categories")){
			req.setAttribute("message","Impossible d'attacher ce canal : cela crerait une boucle dans l'arbre des canaux.");
			req.setAttribute("retour","listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res); 
		}
		if(er.equals("autre")){
			req.setAttribute("message","Une erreur s'est produite. Veuillez ressayer plus tard.");
			req.setAttribute("retour","listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.html").forward(req, res); 
			if(out!=null)		out.close();		
		}

	}
}
