package fr.univvalenciennes.publi.application.admin.servlets;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.univvalenciennes.publi.utils.properties.*;

import fr.univvalenciennes.publi.wsclient.Administration.Categories.*;
import fr.univvalenciennes.publi.wsclient.Administration.Profils.*;
import java.net.URL;

public class MenuCatServlet extends HttpServlet {
	private static Log log =  LogFactory.getLog("MenuServlet");
	
	public String uidUser;
	PrintWriter out;
	
	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
		 new PropertiesManager("applinews.properties");

		// obtention d'un flux de sortie
		out = res.getWriter();

		String choix=null;
		
		log.info("** MenuCatServlet - Recuperation de l'action validee par l'utilisateur ...");
		
		choix = RequestParser.getChoixCat(req,res);
		log.info("** MenuCatServlet - choix : " + choix);
		this.actionChoix(req,res,choix);
	}
	
	private void actionChoix(HttpServletRequest req, HttpServletResponse res, String choix) throws IOException, ServletException{
		ProfilsServicesService profService;
		AdminProfilsSoapBindingStub profStub;
		CategoriesServicesService catService;
		AdminCategoriesSoapBindingStub catStub;
		
		try {
			profService = new ProfilsServicesServiceLocator();
			profStub = (AdminProfilsSoapBindingStub) profService.getadminProfils(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminProfils"));
			catService = new CategoriesServicesServiceLocator();
			catStub = (AdminCategoriesSoapBindingStub) catService.getadminCategories(new URL(PropertiesManager.getProperty("serviceUrl")+"/adminCategories"));
		
			req.getSession().setAttribute("profstub", profStub);
			req.getSession().setAttribute("catstub", catStub);	

			if (choix.equals("formCreer")) {
				// AFFICHAGE DU FORMULAIRE DE CREATION D'UNE CATEGORIE
					
				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |. Ici, on rcupre l'uid de la catgorie choisie
				// qui deviendra la mre de la catgorie cre
				String catEtCatMere = req.getParameter("categorie");
				if(catEtCatMere == null) {
					this.erreur("pas de categorie","",req,res,catStub,profStub); 
				} else { 
					String uidCat;
					int i = catEtCatMere.indexOf("|");
					uidCat = catEtCatMere.substring(i + 1, catEtCatMere.length());
					req.setAttribute("uidcatmere", uidCat);
	
					// redirection vers le formulaire
					getServletConfig().getServletContext().getRequestDispatcher("/formCreationCat.jsp").forward(req, res);
				}
			}

			if (choix.equals("formModifier")) {
				// AFFICHAGE DU FORMULAIRE DE MODIFICATION D'UNE CATEGORIE

				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |. Ici, on rcupre l'uid de la catgorie choisie
				String catEtCatMere = req.getParameter("categorie");
				String uidCat;
				int i = catEtCatMere.indexOf("|");
				uidCat =catEtCatMere.substring(i + 1, catEtCatMere.length());
				req.setAttribute("uidcat", uidCat);

				// On rcupre les attributs de la catgorie pour l'fr.univvalenciennes.publi.application.admin.affichage 
				// par dfaut dans le formulaire
				req.setAttribute("caption",catStub.getCaptionCategories(uidCat));
				req.setAttribute("summary",catStub.getSummaryCategories(uidCat));
				req.setAttribute("editable",(catStub.isRss(uidCat)?"o":"n"));
				req.setAttribute("gifurl",catStub.getGifUrlCategories(uidCat));

				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formModifCat.jsp").forward(req, res);
			}

			if (choix.equals("formAttacher")) {
				// AFFICHAGE DU FORMULAIRE DE CREATION DE LIEN	

				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |. Ici, on rcupre l'uid de la catgorie choisie
				// qui deviendra la mre de la catgorie attache
				String catEtCatMere = req.getParameter("categorie");
				String uidCat = "";
				int i = catEtCatMere.indexOf("|");
				uidCat =catEtCatMere.substring(i + 1, catEtCatMere.length());
				req.getSession().setAttribute("uidcatmere",uidCat);
					
				// redirection vers le formulaire
				getServletConfig().getServletContext().getRequestDispatcher("/formAttacherCat.jsp").forward(req, res);
			}

			if (choix.equals("Attacher")) {
				// CREATION DU LIEN

				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |.
				String catEtCatMereAttach = (String)req.getParameter("categorie");
				int i = catEtCatMereAttach.indexOf("|");
				String uidCatAttach =catEtCatMereAttach.substring(i + 1,catEtCatMereAttach.length());

				// cration du lien dans la base
				boolean cree =catStub.createOrgaCategories((String)req.getSession().getAttribute("uidcatmere"),uidCatAttach);
					
				if (cree){
					// mise  jour de l'arbre affich
					req.getSession().setAttribute("canaux",null);
					req.getSession().setAttribute("uidcatmere",null);
					// le lien est cr. Retour  la liste des catgories
					getServletConfig().getServletContext().getRequestDispatcher("/listeCategories.jsp").forward(req, res);
				}
				else {
					// le lien crerait une boucle					
					erreur("boucle categories", null, req, res,catStub,profStub);
				}

			}

			if (choix.equals("Detacher")) {
				// SUPPRESSION D'UN LIEN
					
				// dans le paramtre "categorie", on stocke l'uid de la catgorie
				// et l'uid de sa mre spars par |.
				String catEtCatMereDetach = req.getParameter("categorie");
				int i = catEtCatMereDetach.indexOf("|");
				String uidCatMereDetach =catEtCatMereDetach.substring(0, i);
				String uidCatDetach =catEtCatMereDetach.substring(i + 1,catEtCatMereDetach.length());
							
				// suppression du lien dans la base
				catStub.deleteOrgaCategories(uidCatMereDetach,uidCatDetach);

				// mise  jour de l'arbre affich
				req.getSession().setAttribute("canaux",null);
						
				// Retour  la liste des catgories
				getServletConfig().getServletContext().getRequestDispatcher("/listeCategories.jsp").forward(req, res);
			}

			if (profStub != null) profStub.close();
	
		} catch (ServletException e){
			throw e;
		} catch (IOException e) {
			throw e;
		} catch (Exception e) {
			erreur("autre","",req,res,null,null);
		} finally {
			out.close();
		}
		
	}
	
	public void erreur(String er,String uid,HttpServletRequest req,HttpServletResponse res,AdminCategoriesSoapBindingStub catStub,AdminProfilsSoapBindingStub profStub)
		throws ServletException, IOException {
		if (er.equals("pas de categorie")) {
			req.setAttribute("message",
				"Vous devez slectionner un canal");
			req.setAttribute("retour", "listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res);
			if (out != null)
				out.close();
		}
		if (er.equals("categorie existe")) {
			req.setAttribute("message",
				"Il existe dj un canal possdant l'identifiant \""
					+ uid
					+ "\". <br>Veuillez choisir un autre identifiant.");
			req.setAttribute("retour", "listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res);
			if (out != null)
				out.close();
		}
		if (er.equals("boucle categories")) {
			req.setAttribute("message",	"Impossible d'attacher ce canal : cela crerait une boucle dans l'arbre des canaux.");
			req.setAttribute("retour", "listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.jsp").forward(req, res);
			if (out != null)
				out.close();
		}
		if (er.equals("autre")) {
			req.setAttribute(
				"message",
				"Une erreur s'est produite. Veuillez ressayer plus tard.");
			req.setAttribute("retour", "listeCategories.jsp");
			getServletConfig().getServletContext().getRequestDispatcher("/erreur.html").forward(req, res);
			if (out != null)
				out.close();
		}
	}
}
